
#include "LookupTables.h"

////////////////// COSINE SINE LOOKUP TABLES

// Returns the cosine value using the lut of a given value
float lut_cos(float value){
	// Cosine is symmetric so convert to absolute
	if (value < 0)
		value = -value;

	// and subtract the "offset"
	//float actualvalue = (float)(value % (2*M_PI));

	while (value >= 2 * (float)M_PI){
		value -= 2 * (float)M_PI;
	}

	// Calculate the value to a discrete value (1024*0.00613592 = 2 pi)
	int discreteValue = (int)(value / 0.00613592);

	return cosLookupTable_f[discreteValue];
}
// Returns the sine value using the lut for a given value
float lut_sin(float value){
	// Convert to cosine
	value -= 0.5*(float)M_PI;
	// Cosine is symmetric so convert to absolute
	if (value < 0)
		value = -value;

	// subtract the "offset" of the original 0-2pi
	//float actualvalue = (float)(value % (float)(2 * M_PI));

	while (value >= (2 * (float)M_PI)){
		value -= (2 * (float)M_PI);
	}

	// Calculate the value to a discrete value (1024*0.00613592 = 2 pi)
	int discreteValue = (int)(value / 0.00613592);

	return cosLookupTable_f[discreteValue];
}

// Returns the cosine value using the lut of a given value
// WARNING, FAST VERSION ONLY WORKS WITH VALUES 0 - 2 PI
float lut_cos_f(float value){
	// Calculate the value to a discrete value (1024*0.00613592 = 2 pi)
	int discreteValue = (int)(value / 0.00613592);

	return cosLookupTable_f[discreteValue];
}

////////////////// END COSINE SINE LOOKUP TABLES

////////////////// HANNING LOOKUP TABLE

// Applies the hanning LUT to the supplied array of data
void applyHanningTable(float* data, int datasize){
	if (datasize == 512){ // Only works for 9 bit data arrays
		for (int i = 0; i < 512; i++){
			data[i] *= hanningTable_f[i];
		}
	}
}

////////////////// END HANNING LOOKUP TABLE