
//
// This file contains all the lookup tables needed for the robot
//

#pragma once
#ifndef _LOOKUP_TABLES_H
#define _LOOKUP_TABLES_H

#define M_PI           3.14159265358979323846


////////////////// COSINE SINE LOOKUP TABLES
// 10 bit lookup table for the cosine function (NOTE lookup table for the sine is generated with an offset)
const float cosLookupTable_f[] = { 1, 0.999981, 0.999925, 0.999831, 0.999699, 0.999529, 0.999322, 0.999078, 0.998795, 0.998476, 0.998118, 0.997723, 0.99729, 0.99682, 0.996313, 0.995767, 0.995185, 0.994565, 0.993907, 0.993212, 0.99248, 0.99171, 0.990903, 0.990058, 0.989177, 0.988258, 0.987301, 0.986308, 0.985278, 0.98421, 0.983105, 0.981964, 0.980785, 0.97957, 0.978317, 0.977028, 0.975702, 0.974339, 0.97294, 0.971504, 0.970031, 0.968522, 0.966976, 0.965394, 0.963776, 0.962121, 0.960431, 0.958703, 0.95694, 0.955141, 0.953306, 0.951435, 0.949528, 0.947586, 0.945607, 0.943593, 0.941544, 0.939459, 0.937339, 0.935184, 0.932993, 0.930767, 0.928506, 0.92621, 0.92388, 0.921514, 0.919114, 0.916679, 0.91421, 0.911706, 0.909168, 0.906596, 0.903989, 0.901349, 0.898674, 0.895966, 0.893224, 0.890449, 0.88764, 0.884797, 0.881921, 0.879012, 0.87607, 0.873095, 0.870087, 0.867046, 0.863973, 0.860867, 0.857729, 0.854558, 0.851355, 0.84812, 0.844854, 0.841555, 0.838225, 0.834863, 0.83147, 0.828045, 0.824589, 0.821102, 0.817585, 0.814036, 0.810457, 0.806848, 0.803208, 0.799537, 0.795837, 0.792107, 0.788346, 0.784557, 0.780737, 0.776888, 0.77301, 0.769103, 0.765167, 0.761202, 0.757209, 0.753187, 0.749136, 0.745058, 0.740951, 0.736817, 0.732654, 0.728464, 0.724247, 0.720002, 0.715731, 0.711432, 0.707107, 0.702755, 0.698376, 0.693971, 0.689541, 0.685084, 0.680601, 0.676093, 0.671559, 0.667, 0.662416, 0.657807, 0.653173, 0.648514, 0.643832, 0.639124, 0.634393, 0.629638, 0.624859, 0.620057, 0.615232, 0.610383, 0.605511, 0.600616, 0.595699, 0.59076, 0.585798, 0.580814, 0.575808, 0.570781, 0.565732, 0.560662, 0.55557, 0.550458, 0.545325, 0.540172, 0.534998, 0.529804, 0.52459, 0.519356, 0.514103, 0.50883, 0.503538, 0.498228, 0.492898, 0.48755, 0.482184, 0.476799, 0.471397, 0.465977, 0.460539, 0.455084, 0.449611, 0.444122, 0.438616, 0.433094, 0.427555, 0.422, 0.41643, 0.410843, 0.405241, 0.399624, 0.393992, 0.388345, 0.382683, 0.377007, 0.371317, 0.365613, 0.359895, 0.354163, 0.348419, 0.342661, 0.33689, 0.331106, 0.32531, 0.319502, 0.313682, 0.30785, 0.302006, 0.296151, 0.290285, 0.284407, 0.27852, 0.272621, 0.266713, 0.260794, 0.254866, 0.248928, 0.24298, 0.237024, 0.231058, 0.225084, 0.219101, 0.21311, 0.207111, 0.201105, 0.19509, 0.189069, 0.18304, 0.177004, 0.170962, 0.164913, 0.158858, 0.152797, 0.14673, 0.140658, 0.134581, 0.128498, 0.122411, 0.116319, 0.110222, 0.104122, 0.0980171, 0.0919089, 0.0857973, 0.0796824, 0.0735645, 0.0674438, 0.0613207, 0.0551952, 0.0490676, 0.0429382, 0.0368072, 0.0306747, 0.0245411, 0.0184067, 0.0122715, 0.00613586, -4.37114e-008, -0.00613595, -0.0122716, -0.0184068, -0.0245412, -0.0306748, -0.0368073, -0.0429383, -0.0490677, -0.0551953, -0.0613208, -0.0674439, -0.0735646, -0.0796825, -0.0857974, -0.091909, -0.0980172, -0.104122, -0.110222, -0.116319, -0.122411, -0.128498, -0.134581, -0.140658, -0.146731, -0.152797, -0.158858, -0.164913, -0.170962, -0.177004, -0.18304, -0.189069, -0.19509, -0.201105, -0.207111, -0.21311, -0.219101, -0.225084, -0.231058, -0.237024, -0.24298, -0.248928, -0.254866, -0.260794, -0.266713, -0.272621, -0.27852, -0.284408, -0.290285, -0.296151, -0.302006, -0.30785, -0.313682, -0.319502, -0.32531, -0.331106, -0.33689, -0.342661, -0.348419, -0.354164, -0.359895, -0.365613, -0.371317, -0.377007, -0.382684, -0.388345, -0.393992, -0.399624, -0.405241, -0.410843, -0.41643, -0.422, -0.427555, -0.433094, -0.438616, -0.444122, -0.449611, -0.455084, -0.460539, -0.465977, -0.471397, -0.476799, -0.482184, -0.48755, -0.492898, -0.498228, -0.503538, -0.50883, -0.514103, -0.519356, -0.52459, -0.529804, -0.534998, -0.540172, -0.545325, -0.550458, -0.55557, -0.560662, -0.565732, -0.570781, -0.575808, -0.580814, -0.585798, -0.59076, -0.595699, -0.600617, -0.605511, -0.610383, -0.615232, -0.620057, -0.62486, -0.629638, -0.634393, -0.639124, -0.643832, -0.648514, -0.653173, -0.657807, -0.662416, -0.667, -0.671559, -0.676093, -0.680601, -0.685084, -0.689541, -0.693971, -0.698376, -0.702755, -0.707107, -0.711432, -0.715731, -0.720003, -0.724247, -0.728464, -0.732654, -0.736817, -0.740951, -0.745058, -0.749137, -0.753187, -0.757209, -0.761202, -0.765167, -0.769103, -0.77301, -0.776888, -0.780737, -0.784557, -0.788346, -0.792107, -0.795837, -0.799537, -0.803208, -0.806848, -0.810457, -0.814036, -0.817585, -0.821103, -0.824589, -0.828045, -0.83147, -0.834863, -0.838225, -0.841555, -0.844854, -0.84812, -0.851355, -0.854558, -0.857729, -0.860867, -0.863973, -0.867046, -0.870087, -0.873095, -0.87607, -0.879012, -0.881921, -0.884797, -0.88764, -0.890449, -0.893224, -0.895966, -0.898674, -0.901349, -0.903989, -0.906596, -0.909168, -0.911706, -0.91421, -0.916679, -0.919114, -0.921514, -0.92388, -0.92621, -0.928506, -0.930767, -0.932993, -0.935184, -0.937339, -0.939459, -0.941544, -0.943594, -0.945607, -0.947586, -0.949528, -0.951435, -0.953306, -0.955141, -0.95694, -0.958703, -0.960431, -0.962121, -0.963776, -0.965394, -0.966976, -0.968522, -0.970031, -0.971504, -0.97294, -0.974339, -0.975702, -0.977028, -0.978317, -0.97957, -0.980785, -0.981964, -0.983105, -0.98421, -0.985278, -0.986308, -0.987301, -0.988258, -0.989177, -0.990058, -0.990903, -0.99171, -0.99248, -0.993212, -0.993907, -0.994565, -0.995185, -0.995767, -0.996313, -0.99682, -0.99729, -0.997723, -0.998118, -0.998476, -0.998795, -0.999078, -0.999322, -0.999529, -0.999699, -0.999831, -0.999925, -0.999981, -1, -0.999981, -0.999925, -0.999831, -0.999699, -0.999529, -0.999322, -0.999078, -0.998795, -0.998476, -0.998118, -0.997723, -0.99729, -0.99682, -0.996313, -0.995767, -0.995185, -0.994565, -0.993907, -0.993212, -0.99248, -0.99171, -0.990903, -0.990058, -0.989177, -0.988258, -0.987301, -0.986308, -0.985278, -0.98421, -0.983105, -0.981964, -0.980785, -0.97957, -0.978317, -0.977028, -0.975702, -0.974339, -0.97294, -0.971504, -0.970031, -0.968522, -0.966976, -0.965394, -0.963776, -0.962121, -0.96043, -0.958703, -0.95694, -0.955141, -0.953306, -0.951435, -0.949528, -0.947586, -0.945607, -0.943593, -0.941544, -0.939459, -0.937339, -0.935183, -0.932993, -0.930767, -0.928506, -0.92621, -0.92388, -0.921514, -0.919114, -0.916679, -0.91421, -0.911706, -0.909168, -0.906596, -0.903989, -0.901349, -0.898674, -0.895966, -0.893224, -0.890449, -0.88764, -0.884797, -0.881921, -0.879012, -0.87607, -0.873095, -0.870087, -0.867046, -0.863973, -0.860867, -0.857729, -0.854558, -0.851355, -0.84812, -0.844854, -0.841555, -0.838225, -0.834863, -0.83147, -0.828045, -0.824589, -0.821102, -0.817585, -0.814036, -0.810457, -0.806847, -0.803208, -0.799537, -0.795837, -0.792107, -0.788346, -0.784557, -0.780737, -0.776888, -0.77301, -0.769103, -0.765167, -0.761202, -0.757209, -0.753187, -0.749136, -0.745058, -0.740951, -0.736817, -0.732654, -0.728464, -0.724247, -0.720002, -0.715731, -0.711432, -0.707107, -0.702755, -0.698376, -0.693971, -0.689541, -0.685084, -0.680601, -0.676093, -0.671559, -0.667, -0.662416, -0.657807, -0.653173, -0.648514, -0.643832, -0.639124, -0.634393, -0.629638, -0.62486, -0.620057, -0.615232, -0.610383, -0.605511, -0.600616, -0.595699, -0.59076, -0.585798, -0.580814, -0.575808, -0.570781, -0.565732, -0.560661, -0.55557, -0.550458, -0.545325, -0.540171, -0.534997, -0.529803, -0.524589, -0.519356, -0.514103, -0.50883, -0.503538, -0.498228, -0.492898, -0.48755, -0.482184, -0.476799, -0.471397, -0.465976, -0.460539, -0.455083, -0.449611, -0.444122, -0.438616, -0.433094, -0.427555, -0.422, -0.416429, -0.410843, -0.405241, -0.399624, -0.393992, -0.388345, -0.382683, -0.377007, -0.371317, -0.365613, -0.359895, -0.354164, -0.348419, -0.342661, -0.33689, -0.331106, -0.32531, -0.319502, -0.313682, -0.30785, -0.302006, -0.296151, -0.290285, -0.284407, -0.27852, -0.272621, -0.266713, -0.260794, -0.254865, -0.248927, -0.24298, -0.237023, -0.231058, -0.225084, -0.219101, -0.21311, -0.207111, -0.201105, -0.19509, -0.189069, -0.18304, -0.177004, -0.170962, -0.164913, -0.158858, -0.152797, -0.14673, -0.140658, -0.134581, -0.128498, -0.122411, -0.116318, -0.110222, -0.104121, -0.0980169, -0.0919087, -0.0857971, -0.0796822, -0.0735643, -0.0674436, -0.0613204, -0.0551949, -0.0490673, -0.0429379, -0.0368073, -0.0306749, -0.0245413, -0.0184068, -0.0122716, -0.00613589, 1.19249e-008, 0.00613591, 0.0122716, 0.0184068, 0.0245413, 0.0306749, 0.0368073, 0.0429384, 0.0490678, 0.0551954, 0.0613209, 0.0674441, 0.0735648, 0.0796827, 0.0857976, 0.0919092, 0.0980174, 0.104122, 0.110223, 0.116319, 0.122411, 0.128498, 0.134581, 0.140658, 0.14673, 0.152797, 0.158858, 0.164913, 0.170962, 0.177004, 0.18304, 0.189069, 0.19509, 0.201105, 0.207111, 0.21311, 0.219101, 0.225084, 0.231058, 0.237024, 0.24298, 0.248928, 0.254866, 0.260794, 0.266713, 0.272622, 0.27852, 0.284408, 0.290285, 0.296151, 0.302006, 0.30785, 0.313682, 0.319502, 0.32531, 0.331106, 0.33689, 0.342661, 0.348419, 0.354164, 0.359895, 0.365613, 0.371317, 0.377008, 0.382684, 0.388345, 0.393992, 0.399624, 0.405242, 0.410843, 0.41643, 0.422001, 0.427555, 0.433094, 0.438617, 0.444122, 0.449612, 0.455084, 0.460539, 0.465976, 0.471397, 0.476799, 0.482184, 0.48755, 0.492898, 0.498228, 0.503538, 0.50883, 0.514103, 0.519356, 0.52459, 0.529804, 0.534998, 0.540172, 0.545325, 0.550458, 0.55557, 0.560662, 0.565732, 0.570781, 0.575808, 0.580814, 0.585798, 0.59076, 0.595699, 0.600616, 0.605511, 0.610383, 0.615232, 0.620057, 0.62486, 0.629638, 0.634393, 0.639125, 0.643832, 0.648515, 0.653173, 0.657807, 0.662416, 0.667, 0.671559, 0.676093, 0.680601, 0.685084, 0.689541, 0.693972, 0.698376, 0.702755, 0.707107, 0.711432, 0.715731, 0.720003, 0.724247, 0.728464, 0.732654, 0.736817, 0.740951, 0.745058, 0.749136, 0.753187, 0.757209, 0.761202, 0.765167, 0.769103, 0.773011, 0.776889, 0.780737, 0.784557, 0.788347, 0.792107, 0.795837, 0.799537, 0.803208, 0.806848, 0.810457, 0.814037, 0.817585, 0.821103, 0.824589, 0.828045, 0.83147, 0.834863, 0.838225, 0.841555, 0.844854, 0.84812, 0.851355, 0.854558, 0.857729, 0.860867, 0.863973, 0.867046, 0.870087, 0.873095, 0.87607, 0.879012, 0.881921, 0.884797, 0.88764, 0.890449, 0.893224, 0.895966, 0.898675, 0.901349, 0.903989, 0.906596, 0.909168, 0.911706, 0.91421, 0.916679, 0.919114, 0.921514, 0.92388, 0.92621, 0.928506, 0.930767, 0.932993, 0.935184, 0.937339, 0.939459, 0.941544, 0.943594, 0.945607, 0.947586, 0.949528, 0.951435, 0.953306, 0.955141, 0.95694, 0.958704, 0.960431, 0.962121, 0.963776, 0.965395, 0.966977, 0.968522, 0.970031, 0.971504, 0.97294, 0.974339, 0.975702, 0.977028, 0.978317, 0.97957, 0.980785, 0.981964, 0.983106, 0.98421, 0.985278, 0.986308, 0.987301, 0.988258, 0.989177, 0.990058, 0.990903, 0.99171, 0.99248, 0.993212, 0.993907, 0.994565, 0.995185, 0.995767, 0.996313, 0.99682, 0.99729, 0.997723, 0.998118, 0.998476, 0.998795, 0.999078, 0.999322, 0.999529, 0.999699, 0.999831, 0.999925, 0.999981 };

// Returns the cosine value using the lut of a given value
float lut_cos(float value);
// Returns the sine value using the lut for a given value
float lut_sin(float value);

// Returns the cosine value using the lut of a given value
// WARNING, FAST VERSION ONLY WORKS WITH VALUES 0 - 2 PI
float lut_cos_f(float value);
////////////////// END COSINE SINE LOOKUP TABLES

////////////////// HANNING LOOKUP TABLE
// 10 bit hanning lookup table
const float hanningTable_f[] = {0, 3.77966e-05, 0.000151181, 0.000340135, 0.000604631, 0.000944629, 0.00136008, 0.00185091, 0.00241706, 0.00305844, 0.00377495, 0.00456648, 0.00543291, 0.00637411, 0.00738995, 0.00848026, 0.00964488, 0.0108836, 0.0121963, 0.0135828, 0.0150428, 0.0165761, 0.0181825, 0.0198617, 0.0216136, 0.0234377, 0.0253339, 0.0273019, 0.0293413, 0.0314519, 0.0336334, 0.0358853, 0.0382074, 0.0405993, 0.0430607, 0.0455912, 0.0481903, 0.0508578, 0.0535932, 0.0563961, 0.059266, 0.0622026, 0.0652053, 0.0682738, 0.0714076, 0.0746061, 0.077869, 0.0811957, 0.0845857, 0.0880385, 0.0915536, 0.0951304, 0.0987685, 0.102467, 0.106226, 0.110044, 0.113922, 0.117857, 0.121851, 0.125901, 0.130009, 0.134172, 0.13839, 0.142663, 0.14699, 0.151371, 0.155804, 0.160289, 0.164826, 0.169413, 0.174051, 0.178737, 0.183472, 0.188255, 0.193085, 0.197962, 0.202884, 0.207851, 0.212862, 0.217917, 0.223014, 0.228153, 0.233334, 0.238554, 0.243814, 0.249113, 0.25445, 0.259824, 0.265234, 0.27068, 0.27616, 0.281674, 0.287222, 0.292801, 0.298412, 0.304053, 0.309724, 0.315423, 0.321151, 0.326905, 0.332686, 0.338492, 0.344323, 0.350177, 0.356053, 0.361952, 0.367871, 0.37381, 0.379768, 0.385745, 0.391739, 0.397749, 0.403774, 0.409814, 0.415868, 0.421935, 0.428013, 0.434102, 0.440201, 0.446309, 0.452426, 0.458549, 0.464679, 0.470814, 0.476953, 0.483096, 0.489242, 0.495389, 0.501537, 0.507685, 0.513831, 0.519975, 0.526117, 0.532254, 0.538387, 0.544513, 0.550633, 0.556746, 0.56285, 0.568944, 0.575028, 0.5811, 0.58716, 0.593207, 0.59924, 0.605258, 0.61126, 0.617246, 0.623213, 0.629162, 0.635091, 0.641, 0.646888, 0.652753, 0.658596, 0.664414, 0.670207, 0.675975, 0.681716, 0.68743, 0.693115, 0.698771, 0.704397, 0.709993, 0.715556, 0.721087, 0.726584, 0.732047, 0.737476, 0.742868, 0.748223, 0.753541, 0.758821, 0.764061, 0.769262, 0.774421, 0.77954, 0.784616, 0.789649, 0.794638, 0.799583, 0.804482, 0.809336, 0.814142, 0.818901, 0.823612, 0.828274, 0.832887, 0.837449, 0.84196, 0.846419, 0.850826, 0.85518, 0.85948, 0.863726, 0.867917, 0.872052, 0.876131, 0.880153, 0.884118, 0.888024, 0.891872, 0.895661, 0.89939, 0.903058, 0.906666, 0.910212, 0.913696, 0.917117, 0.920476, 0.92377, 0.927001, 0.930167, 0.933269, 0.936304, 0.939274, 0.942177, 0.945014, 0.947783, 0.950484, 0.953118, 0.955683, 0.958179, 0.960605, 0.962962, 0.965249, 0.967466, 0.969612, 0.971687, 0.973691, 0.975623, 0.977483, 0.979271, 0.980987, 0.98263, 0.9842, 0.985696, 0.98712, 0.988469, 0.989745, 0.990947, 0.992074, 0.993127, 0.994106, 0.99501, 0.995839, 0.996593, 0.997272, 0.997875, 0.998404, 0.998857, 0.999235, 0.999537, 0.999764, 0.999915, 0.999991, 0.999991, 0.999915, 0.999764, 0.999537, 0.999235, 0.998857, 0.998404, 0.997875, 0.997272, 0.996593, 0.995839, 0.99501, 0.994106, 0.993127, 0.992074, 0.990947, 0.989745, 0.988469, 0.98712, 0.985696, 0.9842, 0.98263, 0.980987, 0.979271, 0.977483, 0.975623, 0.973691, 0.971687, 0.969612, 0.967466, 0.965249, 0.962962, 0.960605, 0.958179, 0.955683, 0.953118, 0.950484, 0.947783, 0.945014, 0.942177, 0.939274, 0.936304, 0.933269, 0.930167, 0.927001, 0.92377, 0.920476, 0.917117, 0.913696, 0.910212, 0.906666, 0.903058, 0.89939, 0.895661, 0.891872, 0.888024, 0.884118, 0.880153, 0.876131, 0.872052, 0.867917, 0.863726, 0.85948, 0.85518, 0.850826, 0.846419, 0.84196, 0.837449, 0.832887, 0.828274, 0.823612, 0.818901, 0.814142, 0.809336, 0.804482, 0.799583, 0.794638, 0.789649, 0.784616, 0.77954, 0.774421, 0.769262, 0.764061, 0.758821, 0.753541, 0.748223, 0.742868, 0.737476, 0.732047, 0.726584, 0.721087, 0.715556, 0.709993, 0.704397, 0.698771, 0.693115, 0.68743, 0.681716, 0.675975, 0.670207, 0.664414, 0.658596, 0.652753, 0.646888, 0.641, 0.635091, 0.629162, 0.623213, 0.617246, 0.61126, 0.605258, 0.59924, 0.593207, 0.58716, 0.5811, 0.575028, 0.568944, 0.56285, 0.556746, 0.550633, 0.544513, 0.538387, 0.532254, 0.526117, 0.519975, 0.513831, 0.507685, 0.501537, 0.495389, 0.489242, 0.483096, 0.476953, 0.470814, 0.464679, 0.458549, 0.452426, 0.446309, 0.440201, 0.434102, 0.428013, 0.421935, 0.415868, 0.409814, 0.403774, 0.397749, 0.391739, 0.385745, 0.379768, 0.37381, 0.367871, 0.361952, 0.356053, 0.350177, 0.344323, 0.338492, 0.332686, 0.326905, 0.321151, 0.315423, 0.309724, 0.304053, 0.298412, 0.292801, 0.287222, 0.281674, 0.27616, 0.27068, 0.265234, 0.259824, 0.25445, 0.249113, 0.243814, 0.238554, 0.233334, 0.228153, 0.223014, 0.217917, 0.212862, 0.207851, 0.202884, 0.197962, 0.193085, 0.188255, 0.183472, 0.178737, 0.174051, 0.169413, 0.164826, 0.160289, 0.155804, 0.151371, 0.14699, 0.142663, 0.13839, 0.134172, 0.130009, 0.125901, 0.121851, 0.117857, 0.113922, 0.110044, 0.106226, 0.102467, 0.0987685, 0.0951304, 0.0915536, 0.0880385, 0.0845857, 0.0811957, 0.077869, 0.0746061, 0.0714076, 0.0682738, 0.0652053, 0.0622026, 0.059266, 0.0563961, 0.0535932, 0.0508578, 0.0481903, 0.0455912, 0.0430607, 0.0405993, 0.0382074, 0.0358853, 0.0336334, 0.0314519, 0.0293413, 0.0273019, 0.0253339, 0.0234377, 0.0216136, 0.0198617, 0.0181825, 0.0165761, 0.0150428, 0.0135828, 0.0121963, 0.0108836, 0.00964488, 0.00848026, 0.00738995, 0.00637411, 0.00543291, 0.00456648, 0.00377495, 0.00305844, 0.00241706, 0.00185091, 0.00136008, 0.000944629, 0.000604631, 0.000340135, 0.000151181, 3.77966e-05, 0};
// Applies the hanning LUT to the supplied array of data
void applyHanningTable(float* data, int datasize);
////////////////// END HANNING LOOKUP TABLE

////////////////// BIT REVERSING LOOKUP TABLE

const int reversebit_lut_i[] = {0, 256, 128, 384, 64, 320, 192, 448, 32, 288, 160, 416, 96, 352, 224, 480, 16, 272, 144, 400, 80, 336, 208, 464, 48, 304, 176, 432, 112, 368, 240, 496, 8, 264, 136, 392, 72, 328, 200, 456, 40, 296, 168, 424, 104, 360, 232, 488, 24, 280, 152, 408, 88, 344, 216, 472, 56, 312, 184, 440, 120, 376, 248, 504, 4, 260, 132, 388, 68, 324, 196, 452, 36, 292, 164, 420, 100, 356, 228, 484, 20, 276, 148, 404, 84, 340, 212, 468, 52, 308, 180, 436, 116, 372, 244, 500, 12, 268, 140, 396, 76, 332, 204, 460, 44, 300, 172, 428, 108, 364, 236, 492, 28, 284, 156, 412, 92, 348, 220, 476, 60, 316, 188, 444, 124, 380, 252, 508, 2, 258, 130, 386, 66, 322, 194, 450, 34, 290, 162, 418, 98, 354, 226, 482, 18, 274, 146, 402, 82, 338, 210, 466, 50, 306, 178, 434, 114, 370, 242, 498, 10, 266, 138, 394, 74, 330, 202, 458, 42, 298, 170, 426, 106, 362, 234, 490, 26, 282, 154, 410, 90, 346, 218, 474, 58, 314, 186, 442, 122, 378, 250, 506, 6, 262, 134, 390, 70, 326, 198, 454, 38, 294, 166, 422, 102, 358, 230, 486, 22, 278, 150, 406, 86, 342, 214, 470, 54, 310, 182, 438, 118, 374, 246, 502, 14, 270, 142, 398, 78, 334, 206, 462, 46, 302, 174, 430, 110, 366, 238, 494, 30, 286, 158, 414, 94, 350, 222, 478, 62, 318, 190, 446, 126, 382, 254, 510, 1, 257, 129, 385, 65, 321, 193, 449, 33, 289, 161, 417, 97, 353, 225, 481, 17, 273, 145, 401, 81, 337, 209, 465, 49, 305, 177, 433, 113, 369, 241, 497, 9, 265, 137, 393, 73, 329, 201, 457, 41, 297, 169, 425, 105, 361, 233, 489, 25, 281, 153, 409, 89, 345, 217, 473, 57, 313, 185, 441, 121, 377, 249, 505, 5, 261, 133, 389, 69, 325, 197, 453, 37, 293, 165, 421, 101, 357, 229, 485, 21, 277, 149, 405, 85, 341, 213, 469, 53, 309, 181, 437, 117, 373, 245, 501, 13, 269, 141, 397, 77, 333, 205, 461, 45, 301, 173, 429, 109, 365, 237, 493, 29, 285, 157, 413, 93, 349, 221, 477, 61, 317, 189, 445, 125, 381, 253, 509, 3, 259, 131, 387, 67, 323, 195, 451, 35, 291, 163, 419, 99, 355, 227, 483, 19, 275, 147, 403, 83, 339, 211, 467, 51, 307, 179, 435, 115, 371, 243, 499, 11, 267, 139, 395, 75, 331, 203, 459, 43, 299, 171, 427, 107, 363, 235, 491, 27, 283, 155, 411, 91, 347, 219, 475, 59, 315, 187, 443, 123, 379, 251, 507, 7, 263, 135, 391, 71, 327, 199, 455, 39, 295, 167, 423, 103, 359, 231, 487, 23, 279, 151, 407, 87, 343, 215, 471, 55, 311, 183, 439, 119, 375, 247, 503, 15, 271, 143, 399, 79, 335, 207, 463, 47, 303, 175, 431, 111, 367, 239, 495, 31, 287, 159, 415, 95, 351, 223, 479, 63, 319, 191, 447, 127, 383, 255, 511};
////////////////// END BIT REVERSING LOOKUP TABLE

////////////////// TWIDDLEFACTOR LOOKUP TABLE

// Twiddle factors are complex, thus two look up tables, one for the real and one for the imaginary part
const float twiddleLookupTable_Real[] = {1.0000000, 0.9999250, 0.9996990, 0.9993220, 0.9987950, 0.9981180, 0.9972900, 0.9963130, 0.9951850, 0.9939070, 0.9924800, 0.9909030, 0.9891770, 0.9873010, 0.9852780, 0.9831050, 0.9807850, 0.9783170, 0.9757020, 0.9729400, 0.9700310, 0.9669760, 0.9637760, 0.9604310, 0.9569400, 0.9533060, 0.9495280, 0.9456070, 0.9415440, 0.9373390, 0.9329930, 0.9285060, 0.9238800, 0.9191140, 0.9142100, 0.9091680, 0.9039890, 0.8986740, 0.8932240, 0.8876400, 0.8819210, 0.8760700, 0.8700870, 0.8639730, 0.8577290, 0.8513550, 0.8448540, 0.8382250, 0.8314700, 0.8245890, 0.8175850, 0.8104570, 0.8032080, 0.7958370, 0.7883460, 0.7807370, 0.7730100, 0.7651670, 0.7572090, 0.7491360, 0.7409510, 0.7326540, 0.7242470, 0.7157310, 0.7071070, 0.6983760, 0.6895410, 0.6806010, 0.6715590, 0.6624160, 0.6531730, 0.6438320, 0.6343930, 0.6248600, 0.6152320, 0.6055110, 0.5956990, 0.5857980, 0.5758080, 0.5657320, 0.5555700, 0.5453250, 0.5349980, 0.5245900, 0.5141030, 0.5035380, 0.4928980, 0.4821840, 0.4713970, 0.4605390, 0.4496110, 0.4386160, 0.4275550, 0.4164300, 0.4052410, 0.3939920, 0.3826830, 0.3713170, 0.3598950, 0.3484190, 0.3368900, 0.3253100, 0.3136820, 0.3020060, 0.2902850, 0.2785200, 0.2667130, 0.2548660, 0.2429800, 0.2310580, 0.2191010, 0.2071110, 0.1950900, 0.1830400, 0.1709620, 0.1588580, 0.1467300, 0.1345810, 0.1224110, 0.1102220, 0.0980171, 0.0857973, 0.0735646, 0.0613207, 0.0490677, 0.0368072, 0.0245412, 0.0122715, 0.0000000, -0.0122715, -0.0245412, -0.0368072, -0.0490677, -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.1102220, -0.1224110, -0.1345810, -0.1467300, -0.1588580, -0.1709620, -0.1830400, -0.1950900, -0.2071110, -0.2191010, -0.2310580, -0.2429800, -0.2548660, -0.2667130, -0.2785200, -0.2902850, -0.3020060, -0.3136820, -0.3253100, -0.3368900, -0.3484190, -0.3598950, -0.3713170, -0.3826830, -0.3939920, -0.4052410, -0.4164300, -0.4275550, -0.4386160, -0.4496110, -0.4605390, -0.4713970, -0.4821840, -0.4928980, -0.5035380, -0.5141030, -0.5245900, -0.5349980, -0.5453250, -0.5555700, -0.5657320, -0.5758080, -0.5857980, -0.5956990, -0.6055110, -0.6152320, -0.6248600, -0.6343930, -0.6438320, -0.6531730, -0.6624160, -0.6715590, -0.6806010, -0.6895410, -0.6983760, -0.7071070, -0.7157310, -0.7242470, -0.7326540, -0.7409510, -0.7491360, -0.7572090, -0.7651670, -0.7730100, -0.7807370, -0.7883460, -0.7958370, -0.8032080, -0.8104570, -0.8175850, -0.8245890, -0.8314700, -0.8382250, -0.8448540, -0.8513550, -0.8577290, -0.8639730, -0.8700870, -0.8760700, -0.8819210, -0.8876400, -0.8932240, -0.8986740, -0.9039890, -0.9091680, -0.9142100, -0.9191140, -0.9238800, -0.9285060, -0.9329930, -0.9373390, -0.9415440, -0.9456070, -0.9495280, -0.9533060, -0.9569400, -0.9604310, -0.9637760, -0.9669760, -0.9700310, -0.9729400, -0.9757020, -0.9783170, -0.9807850, -0.9831050, -0.9852780, -0.9873010, -0.9891770, -0.9909030, -0.9924800, -0.9939070, -0.9951850, -0.9963130, -0.9972900, -0.9981180, -0.9987950, -0.9993220, -0.9996990, -0.9999250, -1.0000000, -0.9999250, -0.9996990, -0.9993220, -0.9987950, -0.9981180, -0.9972900, -0.9963130, -0.9951850, -0.9939070, -0.9924800, -0.9909030, -0.9891770, -0.9873010, -0.9852780, -0.9831050, -0.9807850, -0.9783170, -0.9757020, -0.9729400, -0.9700310, -0.9669760, -0.9637760, -0.9604310, -0.9569400, -0.9533060, -0.9495280, -0.9456070, -0.9415440, -0.9373390, -0.9329930, -0.9285060, -0.9238800, -0.9191140, -0.9142100, -0.9091680, -0.9039890, -0.8986740, -0.8932240, -0.8876400, -0.8819210, -0.8760700, -0.8700870, -0.8639730, -0.8577290, -0.8513550, -0.8448540, -0.8382250, -0.8314700, -0.8245890, -0.8175850, -0.8104570, -0.8032080, -0.7958370, -0.7883460, -0.7807370, -0.7730100, -0.7651670, -0.7572090, -0.7491360, -0.7409510, -0.7326540, -0.7242470, -0.7157310, -0.7071070, -0.6983760, -0.6895410, -0.6806010, -0.6715590, -0.6624160, -0.6531730, -0.6438320, -0.6343930, -0.6248600, -0.6152320, -0.6055110, -0.5956990, -0.5857980, -0.5758080, -0.5657320, -0.5555700, -0.5453250, -0.5349980, -0.5245900, -0.5141030, -0.5035380, -0.4928980, -0.4821840, -0.4713970, -0.4605390, -0.4496110, -0.4386160, -0.4275550, -0.4164300, -0.4052410, -0.3939920, -0.3826830, -0.3713170, -0.3598950, -0.3484190, -0.3368900, -0.3253100, -0.3136820, -0.3020060, -0.2902850, -0.2785200, -0.2667130, -0.2548660, -0.2429800, -0.2310580, -0.2191010, -0.2071110, -0.1950900, -0.1830400, -0.1709620, -0.1588580, -0.1467300, -0.1345810, -0.1224110, -0.1102220, -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677, -0.0368072, -0.0245412, -0.0122715, -0.0000000, 0.0122715, 0.0245412, 0.0368072, 0.0490677, 0.0613207, 0.0735646, 0.0857973, 0.0980171, 0.1102220, 0.1224110, 0.1345810, 0.1467300, 0.1588580, 0.1709620, 0.1830400, 0.1950900, 0.2071110, 0.2191010, 0.2310580, 0.2429800, 0.2548660, 0.2667130, 0.2785200, 0.2902850, 0.3020060, 0.3136820, 0.3253100, 0.3368900, 0.3484190, 0.3598950, 0.3713170, 0.3826830, 0.3939920, 0.4052410, 0.4164300, 0.4275550, 0.4386160, 0.4496110, 0.4605390, 0.4713970, 0.4821840, 0.4928980, 0.5035380, 0.5141030, 0.5245900, 0.5349980, 0.5453250, 0.5555700, 0.5657320, 0.5758080, 0.5857980, 0.5956990, 0.6055110, 0.6152320, 0.6248600, 0.6343930, 0.6438320, 0.6531730, 0.6624160, 0.6715590, 0.6806010, 0.6895410, 0.6983760, 0.7071070, 0.7157310, 0.7242470, 0.7326540, 0.7409510, 0.7491360, 0.7572090, 0.7651670, 0.7730100, 0.7807370, 0.7883460, 0.7958370, 0.8032080, 0.8104570, 0.8175850, 0.8245890, 0.8314700, 0.8382250, 0.8448540, 0.8513550, 0.8577290, 0.8639730, 0.8700870, 0.8760700, 0.8819210, 0.8876400, 0.8932240, 0.8986740, 0.9039890, 0.9091680, 0.9142100, 0.9191140, 0.9238800, 0.9285060, 0.9329930, 0.9373390, 0.9415440, 0.9456070, 0.9495280, 0.9533060, 0.9569400, 0.9604310, 0.9637760, 0.9669760, 0.9700310, 0.9729400, 0.9757020, 0.9783170, 0.9807850, 0.9831050, 0.9852780, 0.9873010, 0.9891770, 0.9909030, 0.9924800, 0.9939070, 0.9951850, 0.9963130, 0.9972900, 0.9981180, 0.9987950, 0.9993220, 0.9996990, 0.9999250};

const float twiddleLookupTable_Imaginary[] = {0.0000000, -0.0122715, -0.0245412, -0.0368072, -0.0490677, -0.0613207, -0.0735646, -0.0857973, -0.0980171, -0.1102220, -0.1224110, -0.1345810, -0.1467300, -0.1588580, -0.1709620, -0.1830400, -0.1950900, -0.2071110, -0.2191010, -0.2310580, -0.2429800, -0.2548660, -0.2667130, -0.2785200, -0.2902850, -0.3020060, -0.3136820, -0.3253100, -0.3368900, -0.3484190, -0.3598950, -0.3713170, -0.3826830, -0.3939920, -0.4052410, -0.4164300, -0.4275550, -0.4386160, -0.4496110, -0.4605390, -0.4713970, -0.4821840, -0.4928980, -0.5035380, -0.5141030, -0.5245900, -0.5349980, -0.5453250, -0.5555700, -0.5657320, -0.5758080, -0.5857980, -0.5956990, -0.6055110, -0.6152320, -0.6248600, -0.6343930, -0.6438320, -0.6531730, -0.6624160, -0.6715590, -0.6806010, -0.6895410, -0.6983760, -0.7071070, -0.7157310, -0.7242470, -0.7326540, -0.7409510, -0.7491360, -0.7572090, -0.7651670, -0.7730100, -0.7807370, -0.7883460, -0.7958370, -0.8032080, -0.8104570, -0.8175850, -0.8245890, -0.8314700, -0.8382250, -0.8448540, -0.8513550, -0.8577290, -0.8639730, -0.8700870, -0.8760700, -0.8819210, -0.8876400, -0.8932240, -0.8986740, -0.9039890, -0.9091680, -0.9142100, -0.9191140, -0.9238800, -0.9285060, -0.9329930, -0.9373390, -0.9415440, -0.9456070, -0.9495280, -0.9533060, -0.9569400, -0.9604310, -0.9637760, -0.9669760, -0.9700310, -0.9729400, -0.9757020, -0.9783170, -0.9807850, -0.9831050, -0.9852780, -0.9873010, -0.9891770, -0.9909030, -0.9924800, -0.9939070, -0.9951850, -0.9963130, -0.9972900, -0.9981180, -0.9987950, -0.9993220, -0.9996990, -0.9999250, -1.0000000, -0.9999250, -0.9996990, -0.9993220, -0.9987950, -0.9981180, -0.9972900, -0.9963130, -0.9951850, -0.9939070, -0.9924800, -0.9909030, -0.9891770, -0.9873010, -0.9852780, -0.9831050, -0.9807850, -0.9783170, -0.9757020, -0.9729400, -0.9700310, -0.9669760, -0.9637760, -0.9604310, -0.9569400, -0.9533060, -0.9495280, -0.9456070, -0.9415440, -0.9373390, -0.9329930, -0.9285060, -0.9238800, -0.9191140, -0.9142100, -0.9091680, -0.9039890, -0.8986740, -0.8932240, -0.8876400, -0.8819210, -0.8760700, -0.8700870, -0.8639730, -0.8577290, -0.8513550, -0.8448540, -0.8382250, -0.8314700, -0.8245890, -0.8175850, -0.8104570, -0.8032080, -0.7958370, -0.7883460, -0.7807370, -0.7730100, -0.7651670, -0.7572090, -0.7491360, -0.7409510, -0.7326540, -0.7242470, -0.7157310, -0.7071070, -0.6983760, -0.6895410, -0.6806010, -0.6715590, -0.6624160, -0.6531730, -0.6438320, -0.6343930, -0.6248600, -0.6152320, -0.6055110, -0.5956990, -0.5857980, -0.5758080, -0.5657320, -0.5555700, -0.5453250, -0.5349980, -0.5245900, -0.5141030, -0.5035380, -0.4928980, -0.4821840, -0.4713970, -0.4605390, -0.4496110, -0.4386160, -0.4275550, -0.4164300, -0.4052410, -0.3939920, -0.3826830, -0.3713170, -0.3598950, -0.3484190, -0.3368900, -0.3253100, -0.3136820, -0.3020060, -0.2902850, -0.2785200, -0.2667130, -0.2548660, -0.2429800, -0.2310580, -0.2191010, -0.2071110, -0.1950900, -0.1830400, -0.1709620, -0.1588580, -0.1467300, -0.1345810, -0.1224110, -0.1102220, -0.0980171, -0.0857973, -0.0735646, -0.0613207, -0.0490677, -0.0368072, -0.0245412, -0.0122715, -0.0000000, 0.0122715, 0.0245412, 0.0368072, 0.0490677, 0.0613207, 0.0735646, 0.0857973, 0.0980171, 0.1102220, 0.1224110, 0.1345810, 0.1467300, 0.1588580, 0.1709620, 0.1830400, 0.1950900, 0.2071110, 0.2191010, 0.2310580, 0.2429800, 0.2548660, 0.2667130, 0.2785200, 0.2902850, 0.3020060, 0.3136820, 0.3253100, 0.3368900, 0.3484190, 0.3598950, 0.3713170, 0.3826830, 0.3939920, 0.4052410, 0.4164300, 0.4275550, 0.4386160, 0.4496110, 0.4605390, 0.4713970, 0.4821840, 0.4928980, 0.5035380, 0.5141030, 0.5245900, 0.5349980, 0.5453250, 0.5555700, 0.5657320, 0.5758080, 0.5857980, 0.5956990, 0.6055110, 0.6152320, 0.6248600, 0.6343930, 0.6438320, 0.6531730, 0.6624160, 0.6715590, 0.6806010, 0.6895410, 0.6983760, 0.7071070, 0.7157310, 0.7242470, 0.7326540, 0.7409510, 0.7491360, 0.7572090, 0.7651670, 0.7730100, 0.7807370, 0.7883460, 0.7958370, 0.8032080, 0.8104570, 0.8175850, 0.8245890, 0.8314700, 0.8382250, 0.8448540, 0.8513550, 0.8577290, 0.8639730, 0.8700870, 0.8760700, 0.8819210, 0.8876400, 0.8932240, 0.8986740, 0.9039890, 0.9091680, 0.9142100, 0.9191140, 0.9238800, 0.9285060, 0.9329930, 0.9373390, 0.9415440, 0.9456070, 0.9495280, 0.9533060, 0.9569400, 0.9604310, 0.9637760, 0.9669760, 0.9700310, 0.9729400, 0.9757020, 0.9783170, 0.9807850, 0.9831050, 0.9852780, 0.9873010, 0.9891770, 0.9909030, 0.9924800, 0.9939070, 0.9951850, 0.9963130, 0.9972900, 0.9981180, 0.9987950, 0.9993220, 0.9996990, 0.9999250, 1.0000000, 0.9999250, 0.9996990, 0.9993220, 0.9987950, 0.9981180, 0.9972900, 0.9963130, 0.9951850, 0.9939070, 0.9924800, 0.9909030, 0.9891770, 0.9873010, 0.9852780, 0.9831050, 0.9807850, 0.9783170, 0.9757020, 0.9729400, 0.9700310, 0.9669760, 0.9637760, 0.9604310, 0.9569400, 0.9533060, 0.9495280, 0.9456070, 0.9415440, 0.9373390, 0.9329930, 0.9285060, 0.9238800, 0.9191140, 0.9142100, 0.9091680, 0.9039890, 0.8986740, 0.8932240, 0.8876400, 0.8819210, 0.8760700, 0.8700870, 0.8639730, 0.8577290, 0.8513550, 0.8448540, 0.8382250, 0.8314700, 0.8245890, 0.8175850, 0.8104570, 0.8032080, 0.7958370, 0.7883460, 0.7807370, 0.7730100, 0.7651670, 0.7572090, 0.7491360, 0.7409510, 0.7326540, 0.7242470, 0.7157310, 0.7071070, 0.6983760, 0.6895410, 0.6806010, 0.6715590, 0.6624160, 0.6531730, 0.6438320, 0.6343930, 0.6248600, 0.6152320, 0.6055110, 0.5956990, 0.5857980, 0.5758080, 0.5657320, 0.5555700, 0.5453250, 0.5349980, 0.5245900, 0.5141030, 0.5035380, 0.4928980, 0.4821840, 0.4713970, 0.4605390, 0.4496110, 0.4386160, 0.4275550, 0.4164300, 0.4052410, 0.3939920, 0.3826830, 0.3713170, 0.3598950, 0.3484190, 0.3368900, 0.3253100, 0.3136820, 0.3020060, 0.2902850, 0.2785200, 0.2667130, 0.2548660, 0.2429800, 0.2310580, 0.2191010, 0.2071110, 0.1950900, 0.1830400, 0.1709620, 0.1588580, 0.1467300, 0.1345810, 0.1224110, 0.1102220, 0.0980171, 0.0857973, 0.0735646, 0.0613207, 0.0490677, 0.0368072, 0.0245412, 0.0122715}; 

////////////////// END TWIDDLEFACTOR LOOKUP TABLE

#endif