
// This file first preprocesses a 512 long data array by:
// - Calculating and substracting the mean
// - Applying a hann window
// It then applies a radix-2 Cooley Tukey FFT 
// then it applies an equalizer that multiplies frequencies by different values
// After, it transforms it back

#pragma once
#ifndef _DFT_H_
#define _DFT_H_

#include <string.h> // Only for memcpy
#include "LookupTables.h"
#include "complexmath.h"


// Do the Equalizer as described above
void performEqualizer(float* datain,float* dataout, int datalength);

// Performs a radix-2 cooley tukey FFT on the data array to transform to frequency
void reverseCooleyTukeyRadix2(float* data, complex_num* dataout, int datalength);

//perform the equalize function
void equalizer(complex_num* data);

//Performs a radix-2 cooley tukey FFT on the data array to transform back to time
void cooleyTukeyBack (float* dataout,complex_num* data, int datalength);

// Calculates and subtracts the signal mean
void subMean(float* data, int datalength);


#endif