#include "mbed.h"
#include "rtos.h"

I2C acc(p9, p10);
DigitalIn btn(p11);
Serial pc(USBTX,USBRX);

const int negPad = 0xfffff000;
char * BTN_ID = "BTN";
char * ACC_ID = "ACC";

struct ButtonEvent{
    char id[3];
    bool state;
};

struct AccelerometerEvent {
    char id[3];
    char x[2], y[2], z[2];
};

Thread consumer;
Thread producer;

Ticker timer;
MemoryPool<ButtonEvent, 32> btnPool;
MemoryPool<AccelerometerEvent, 32> accPool;
Queue<void, 64> event;


int getInt(char* data)
{
    int x = ((int)data[0])<<4;
    x |= data[1]>>4;
    if ((data[0] & 0x80) != 0) {
        // négatif alors padding
        x |= negPad;
    }
    return x;
}

void btnConsumer(ButtonEvent* data){
     pc.printf("Event BTN: %s \r\n",(bool)data->state ? "Pressed" : "Released");
}
void accConsumer(AccelerometerEvent* data){
    int x = getInt(data->x);
    int y = getInt(data->y);
    int z = getInt(data->z);
    
    float x_g = (float)x/1024.0f;
    float y_g = (float)y/1024.0f;
    float z_g = (float)z/1024.0f;
    pc.printf("Event ACC: x=%.02fg ,y=%.02fg , z=%.02fg \r\n ",x_g,y_g,z_g);  
}

void eventConsumer(){
    while(true){
        void* ptr = event.get().value.p;
        char c0 = *((char*)(ptr));
        char c1 = *((char*)(ptr+1));
        char c2 = *((char*)(ptr+2));
        
        if (c0 == 'B' && c1 == 'T' && c2 == 'N' ){
            ButtonEvent* BtnEvt = (ButtonEvent*)ptr;
            btnConsumer(BtnEvt);
            btnPool.free(BtnEvt);
        }
        else if (c0 == 'A' && c1 == 'C' && c2 == 'C' ){
            AccelerometerEvent* AccEvt = (AccelerometerEvent*)ptr;
            accConsumer(AccEvt);
            accPool.free(AccEvt);
    
        }
        else {
            pc.printf("Erreur event");
        }
    }
}

void generateAcc(){
    AccelerometerEvent* accEvt = accPool.alloc();
    char cmd[1];
    char data[6];

    pc.printf("Event ACC");
    cmd[0] = 0x01;
    wait(0.1);
    acc.write(0x1d<<1,cmd,1,true);
    acc.read(0x1d<<1,data,6);
    accEvt->id[0]= 'A';
    accEvt->id[1]= 'C';
    accEvt->id[2]= 'C';
    accEvt->x[0] = data[0];
    accEvt->x[1] = data[1];
    accEvt->y[0] = data[2];
    accEvt->y[1] = data[3];
    accEvt->z[0] = data[4];
    accEvt->z[1] = data[5];
    
    event.put(accEvt);  
}
void generateBtn(bool state){
    
    ButtonEvent* btnEvt = btnPool.alloc(); 
    btnEvt->id[0]= 'B';
    btnEvt->id[1]= 'T';
    btnEvt->id[2]= 'N';
    btnEvt->state = state;
    event.put(btnEvt);  
}
void producerMain(){
    while(true){
        Thread::signal_wait(0x1);
        generateBtn(btn.read());
        generateAcc();
    }
    
}
void tick(){
    producer.signal_set(0x1);
}
int main() {
    producer.start(callback(producerMain));
    consumer.start(callback(eventConsumer));
    
    timer.attach(&tick, 1);
    
    Thread::wait(osWaitForever);
}
