#ifndef CRC_16_H
#define CRC_16_H

#include <stdint.h>

#define DEFAULT_POLYNOME       0x8005
#define DEFAULT_INITIAL_VALUE  0x0000
#define DEFAULT_XOR_OUT_VALUE  0x0000
#define DEFAULT_REVERSE_INPUT  true
#define DEFUALT_REVERSE_OUTPUT true

struct crc_t{
    uint16_t polynome;
    uint16_t registre;
    uint16_t initialValue;
    uint16_t xorOut;
    bool reverseIn;
    bool reverseOut;
};

void initLookup(uint16_t polynome = DEFAULT_POLYNOME);

crc_t initCrc(uint16_t polynome = DEFAULT_POLYNOME,
              uint16_t initialValue = DEFAULT_INITIAL_VALUE,
              uint16_t xorOut = DEFAULT_XOR_OUT_VALUE,
              bool reverseIn = DEFAULT_REVERSE_INPUT,
              bool reverseOut = DEFUALT_REVERSE_OUTPUT);

void resetCrc(crc_t & crc);

void addByteToCrc(crc_t & crc, uint8_t byte);

uint16_t getCrc(crc_t & crc);

#endif