#include "crc16.h"

// Utilities functions
uint8_t reverseByte(uint8_t byte){
    uint8_t out = 0x00;
    for (int i = 0; i < 8; ++i){
        out <<= 1;
        out |= byte & 0x01;
        byte >>= 1;
    }
    return out;
}

uint16_t reverseRegistre(uint16_t registre){
    uint16_t out = 0x0000;
    for (int i = 0; i < 16; ++i){
        out <<= 1;
        out |= registre & 0x01;
        registre >>= 1;
    }
    return out;
}

// Lookup Table function
uint16_t crcLookupPoly = 0x0000;
uint16_t crcLookup[256];

void initLookup(uint16_t polynome){
    if (crcLookupPoly == polynome){
        return;
    }
    crcLookupPoly = polynome;
    uint16_t registre;
    for(int i = 0; i < 256; ++i){
        registre = 0x0000;
        
        for(int j = 7; j > -1; --j){
            
            // On isole un bit
            int bit = (i >> j) & 0x01;
            registre ^= (bit << 15);
            
            // Si le bit 15 est un 1, il faut faire un XOR avec le polynome après le leftshift
            bool doPolyXor = (registre & 0x8000) != 0;
            
            registre <<= 1;
            
            if (doPolyXor){
                registre ^= polynome;
            }
        }
        crcLookup[i] = registre;
    }
}


// Crc Functions
crc_t initCrc(uint16_t polynome,
              uint16_t initialValue,
              uint16_t xorOut,
              bool reverseIn,
              bool reverseOut){
    crc_t temp;
    temp.polynome = polynome;
    temp.initialValue = initialValue;
    temp.xorOut = xorOut;
    temp.reverseIn = reverseIn;
    temp.reverseOut = reverseOut;
    
    resetCrc(temp);
    return temp;
}

void resetCrc(crc_t & crc){
    crc.registre = crc.initialValue;
}

void addByteToCrc(crc_t & crc, uint8_t byte){
    if (crcLookupPoly != crc.polynome){
        initLookup(crc.polynome);
    }
    
    if (crc.reverseIn){
        byte = reverseByte(byte);
    }
    
    uint8_t index = (crc.registre >> 8);
    index ^= byte;
    
    crc.registre = (crc.registre << 8) ^ crcLookup[index];
}

uint16_t getCrc(crc_t & crc){
    uint16_t out = crc.registre;
    
    if (crc.reverseOut){
        out = reverseRegistre(out);
    }
    
    out ^= crc.xorOut;
    
    return out;
}