/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "ReceiverIR.h"
#include "rtos.h"
#include <stdint.h>
#include "platform/mbed_thread.h"

Serial pc(USBTX, USBRX);


DigitalIn button(p15);
// ポートp15を赤外線受信モジュールの接続先に指定
ReceiverIR ir_rx(p15);
RemoteIR::Format format;
uint8_t buf[32];
uint32_t bitcount;
uint32_t code;

void rimokon();

void rimokon(/*void const *argument*/){  
        
       
        // 受信待ち
        if (ir_rx.getState() == ReceiverIR::Received) {
            // コード受信
            bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            if(bitcount > 1){
                // 受信成功
                code=0;
                for(int j=0;j<4;j++){
                    code+=(buf[j]<<(8*(3-j)));
                }
                pc.printf("%0x\r\n",code);
                switch(code){
                    case 0x40bf0ff0://入力切換
                        pc.printf("入力切換\r\n");
                        break;
                    case 0x40bf12ed://電源
                        pc.printf("電源\r\n");
                        break;
                    case 0x40bf7b84://地アナ
                        pc.printf("地アナ\r\n");
                        break;
                    case 0x40bf7a85://地デジ
                        pc.printf("地デジ\r\n");
                        break;
                    case 0x40bf7c83://BS
                        pc.printf("BS\r\n");
                        break;
                    case 0x40bf7d82://CS
                        pc.printf("CS\r\n");
                        break;
                    
                    case 0x40bf01fe://1
                        pc.printf("1\r\n");
                        break;
                    case 0x40bf02fd://2
                        pc.printf("2\r\n");
                        break;
                    case 0x40bf03fc://3
                        pc.printf("3\r\n");
                        break;
                    case 0x40bf04fb://4
                        pc.printf("4\r\n");
                        break;
                    case 0x40bf05fa://5
                        pc.printf("5\r\n");
                        break;
                    case 0x40bf06f9://6
                        pc.printf("6\r\n");
                        break;
                    case 0x40bf07f8://7
                        pc.printf("7\r\n");
                        break;
                    case 0x40bf08f7://8
                        pc.printf("8\r\n");
                        break;
                    case 0x40bf09f6://9
                        pc.printf("9\r\n");
                        break;
                    case 0x40bf0af5://10
                        pc.printf("10\r\n");
                        break;
                    case 0x40bf0bf4://11
                        pc.printf("11\r\n");
                        break;
                    case 0x40bf0cf3://12
                        pc.printf("12\r\n");
                        break;
                    case 0x40bf1be4://チャンネル↑
                        pc.printf("チャンネル↑\r\n");
                        break;
                    case 0x40bf1fe0://チャンネル↓
                        pc.printf("チャンネル↓\r\n");
                        break;
                    case 0x40bf1ce3://画面表示
                        pc.printf("画面表示\r\n");
                        break;
                    case 0x40bf10ef://消音
                        pc.printf("消音\r\n");
                        break;
                    case 0x40bf27d8://クイック
                        pc.printf("クイック\r\n");
                        break;    
                    case 0x40bf1ae5://音量↑
                        pc.printf("音量↑\r\n");
                        break;
                    case 0x40bf1ee1://音量↓
                        pc.printf("音量↓\r\n");
                        break;
                    case 0x40be34cb://レグザリンク
                        pc.printf("レグザリンク\r\n");
                        break;
                    case 0x40bf6e91://番組表
                        pc.printf("番組表\r\n");
                        break;
                    case 0x40bf3bc4://戻る
                        pc.printf("戻る\r\n");
                        break;
                    case 0x40bf3cc3://終了
                        pc.printf("終了\r\n");
                        break;
                    case 0x40bf3ec1://↑
                        pc.printf("↑\r\n");
                        break;
                    case 0x40bf3fc0://↓
                        pc.printf("↓\r\n");
                        break;
                    case 0x40bf5fa0://←
                        pc.printf("←\r\n");
                        break;
                    case 0x40bf5ba4://→
                        pc.printf("→\r\n");
                        break;
                    case 0x40bf3dc2://決定
                        pc.printf("決定\r\n");
                        break;
                    case 0x40bf738c://青
                        pc.printf("青\r\n");
                        break;
                    case 0x40bf748b://赤
                        pc.printf("赤\r\n");
                        break;
                    case 0x40bf758a://緑
                        pc.printf("緑\r\n");
                        break;
                    case 0x40bf7689://黄
                        pc.printf("黄\r\n");
                        break;
                    case 0x43bc14eb://dデータ
                        pc.printf("dデータ\r\n");
                        break;
                    case 0x40bf50af://静止
                        pc.printf("静止\r\n");
                        break;
                    case 0x40bf59a6://おまかせ映像
                        pc.printf("おまかせ映像\r\n");
                        break;
                    case 0x40bf13ec://音声切換
                        pc.printf("音声切換\r\n");
                        break;
                    
                    
                    default:
                        ;
                }
            }
        }
        
}

int main() {
    
    //RtosTimer rimokon_timer(rimokon, osTimerPeriodic, (void *)0); // set RTOS timer for sensor
    //rimokon_timer.start(10);
    //Thread thread1(rimokon , NULL , osPriorityHigh);
    while(1){
        if(button.read()==0){
            rimokon();
        }    
    }
}