#include "point.h"
#include "models.h"

Person::Person(){
    p.x = DEFAULT_X;
    p.y = DEFAULT_Y;
    jump_count = 0;
    jump_time = 0;
}

point Person::update(int h){
    int height = LCD_Y - h - 1;
    if(jump_time > 0){
        //while jumpping
        p.y -= JUMP_SIZE;
        jump_time--; 
    }else{
        //while down or go
        if(isGround(height)){
            //while go
            jump_count = 0;
        }else{
            //while down
            p.y += JUMP_SIZE;
        }
    }
    return p;
}

point Person::jump(){
    //start jump
    if(jump_count < MAX_JUMP_COUNT){
        p.y -= JUMP_SIZE;
        jump_time = MAX_JUMP_TIME;
        jump_count++;
    }
    return p;
}

bool Person::isGround(int height){
    return height == (p.y + PERSON_SIZE - 1);
}