#ifndef models_h
#define models_h

#include "point.h"
#include "mbed.h"
//LCD params
#define LCD_X 128
#define LCD_Y 32

//Stage params
#define ONE_STEP_SIZE 25
//#define STEP_NUM LCD_X/ONE_STEP_SIZE+1
#define ALL_LENGTH 1000 //stage all length
#define STAGE_V 1

//Person params
#define PERSON_SIZE 6 //person is 6 * 6 dots
#define DEFAULT_X  2
#define DEFAULT_Y  25  //31-7+1
#define MAX_JUMP_TIME 7
#define MAX_JUMP_COUNT 2
#define JUMP_SIZE 2
#define GAME_OVER -1

//Bullet params
#define BULLET_SIZE 5 //bullet is 5*5
#define HIGH_SPEED 4
#define NOMAL_SOEED 3
#define LOW_SPEED 2
#define HIGH 17
#define MIDDLE 12
#define LOW 7

class Person
{
private:
    point p;
    int jump_count;
    int jump_time;
    bool isGround(int height);

public:
    Person();
    point update(int height);
    point jump();
};

class Bullet
{
private:
    point p;
    int v;
public:
    Bullet(point p, int v);
    point update();
};

class Stage
{
private:
    int length;
    int stage[LCD_X]; 
    int nextStep();
public:
    Stage();
    int* getStage();
    int getLength();
};

#endif