#include "mbed.h"
#include "C12832_lcd.h"
#include "Arial_9.h"
#include "Small_7.h"
#include "graphics.h"
#include "models.h"
#include "rtos.h"
#include "point.h"
#include "stdlib.h"
#include "convert.h"

C12832_LCD lcd;

// down: p12, left: p13, center: p14, up: p15, right: p16
InterruptIn button(p14);
AnalogIn aIn(p20);

Mutex jump_mtx;
Mutex update_mtx;
Mutex bullet_mtx;

Person h;
Stage stage;
Serial pc(USBTX, USBRX); // tx, rx
Bullet* b = NULL;
Timer t;

int* wall_height;
int white_board[LCD_Y][LCD_X];

Bitmap make_wall(){
    Converter converter;
    wall_height = stage.getStage();

    //initialize white board
     for(int i = 0; i < LCD_Y; i++){
        for (int j = 0; j < LCD_X; j++){
            white_board[i][j] = 0;
        }
    }
    
    for(int i = 0; i < LCD_Y; i++){
        for(int j = 0; j < LCD_X ; j++){
            if(wall_height[j] > (LCD_Y - 1 - i)){
                white_board[i][j] = 1;
            }
        }
    }
    
    return converter.convert(white_board);
    
}

void call_jump(){
    h.jump();
}

void jump_receive(void const *argument){
    while(true){
        jump_mtx.lock();
        wait(0.01);
        button.rise(&call_jump);
        jump_mtx.unlock();
        //Thread::wait(0.1);
    }
}

void bullet_receive(void const *argument){
    //bullet option
    int fast = HIGH_SPEED;
    int normal = NOMAL_SOEED;
    int slow = LOW_SPEED;
    int high = HIGH;
    int middle = MIDDLE;
    int low = LOW;

    point start;
    start.x = LCD_X - 1;
    char c;
    while(true){
        t.start();
        c = pc.getc();
        bullet_mtx.lock();
        if(c >= '1' && c <= '9' && t.read() > 5.0){
            b = NULL;
            switch(c){
                case '1':
                    start.y = LCD_Y - high;
                    b = &Bullet(start, slow);
                    break;
                case '2':
                    start.y = LCD_Y - high;
                    b = &Bullet(start, normal);
                    break;
                case '3':
                    start.y = LCD_Y - high;
                    b = &Bullet(start, fast);
                    break;
                case '4':
                    start.y = LCD_Y - middle;
                    b = &Bullet(start, slow);
                    break;
                case '5':
                    start.y = LCD_Y - middle;
                    b = &Bullet(start, normal);
                    break;
                case '6':
                    start.y = LCD_Y - middle;
                    b = &Bullet(start, fast);
                    break;
                case '7':
                    start.y = LCD_Y - low;
                    b = &Bullet(start, slow);
                    break;
                case '8':
                    start.y = LCD_Y - low;
                    b = &Bullet(start, normal);
                    break;
                case '9':
                    start.y = LCD_Y - low;
                    b = &Bullet(start, fast);
                    break;
                default:
                    break;
            }
            t.reset();
        }
        bullet_mtx.unlock();
    }
}

int xabs(double x,double y){
  if(x>=y){
    return(x-y);
  }
  else if(y>x){
    return(y-x);
  }
    return 0;
}

bool bullet_collision(point p_person, point p_bullet){
    //彈当たり判定
    double person_center_x = p_person.x + PERSON_SIZE / 2;
    double person_center_y = p_person.y + PERSON_SIZE / 2;
    
    double bullet_center_x = p_bullet.x + BULLET_SIZE / 2;
    double bullet_center_y = p_bullet.y + BULLET_SIZE / 2;
    
    if(xabs(person_center_x, bullet_center_x) < (PERSON_SIZE / 2 + BULLET_SIZE / 2)){
        if(xabs(person_center_y, bullet_center_y) < (PERSON_SIZE / 2 + (BULLET_SIZE - 2) / 2)){
            return true;
        }
    }
    
    return false;
}

bool wall_collision(point p_person){
    //壁衝突判定と穴落ち判定
    int x = p_person.x + 4;
    int y = p_person.y + 6;
    if(wall_height[x - 1] > (LCD_Y - y)){
        return true;
    }
    return false;
}

int main(){
    point p_person, p_bullet;
    Thread jump_th(jump_receive);
    Thread bullet_th(bullet_receive);
    lcd.setmode(XOR);
    bool gameover = false;
    bool isDisplay = false;
    srand((int)(aIn * 100));
    Bitmap wall;
    
    
    printf("New Game Start\n");
    printf("Bullet Option\n");
    printf("       slow    normal  fast\n");
    printf("high     1       2       3\n");
    printf("middle   4       5       6\n");
    printf("low      7       8       9\n");
    
    while(true){
        if(!gameover){
            wall = make_wall();
            update_mtx.lock();
            p_person = h.update(wall_height[3]);
            //p_person = h.update(1);
            if(b != NULL){
                p_bullet = b->update();
            }
            
            update_mtx.unlock();
            
            gameover |= bullet_collision(p_person, p_bullet);
            gameover |= wall_collision(p_person);
            
            lcd.cls();
            lcd.print_bm(bitmPlayer,p_person.x,p_person.y);
            lcd.print_bm(wall,0,0);
            if(b != NULL){
                lcd.print_bm(bitmBullet_graphics, p_bullet.x, p_bullet.y);
            }
            lcd.copy_to_lcd();
            wait(0.02);
            lcd.cls();
            lcd.print_bm(bitmPlayerB,p_person.x,p_person.y);
            lcd.print_bm(wall,0,0);
            if(b != NULL){
                lcd.print_bm(bitmBullet_graphics, p_bullet.x, p_bullet.y);
            }
            lcd.copy_to_lcd();
            wait(0.02);
        } else {
            if(!isDisplay){
                lcd.cls();
                lcd.locate(5,10);
                lcd.printf("Game Over.");
                lcd.locate(5,22);
                lcd.printf("Your record is %d.", stage.getLength());
                lcd.copy_to_lcd();
                isDisplay = true;
            }
            
        }
    }
}