#include "point.h"
#include "models.h"
#include "mbed.h"
#include <stdlib.h>
#include <stdio.h> 

#define MAX_LEN ONE_STEP_SIZE*3

Stage::Stage(){
    length = LCD_X;
    for(int i = 0; i < LCD_X; i++){
        stage[i] = 1;
    }
}

int* Stage::getStage(){
    if((length % ONE_STEP_SIZE) == 0){
        //get new step
        for(int i = 0; i < LCD_X;i++){
            if(i == LCD_X - 1){
                //make random
                int r = nextStep(); //TODO
                stage[i] = r;
            }else{
                //slide
                stage[i] = stage[i+1];
            }
        }
    }else{
        //simly slide stage
        for(int i = 0; i < LCD_X;i++){
            if(i == LCD_X - 1){
                //the same height
                stage[i] = stage[i-1]; 
            }else{
                //slide
                stage[i] = stage[i+1];
            }
        }
    }
    length++;
    return stage;
}

int Stage::nextStep(){
    if(stage[LCD_X - 1] == 0){
        int t = rand()%6;
        if(t % 2==0){
            t++;
        }
        return t;
    }
    if(stage[LCD_X - 1] == stage[LCD_X - 2 - ONE_STEP_SIZE]){
        return stage[LCD_X - 1] + 4;
    }else{
        if(rand()%10 == 0){
            return 0;
        }
        int start = stage[LCD_X - 1] - 8;
        if(start < 0){
            start = 0;
        }
        int end = stage[LCD_X - 1] + 8;
        if(end > 20){
            end = 20;
        }
        int tmp = start + rand()%(start - end + 1);
        if((tmp % 2 == 0) && (tmp != 0)){
            tmp++;
        }
        return tmp;
    }
}


int Stage::getLength(){
    return length - 128;
}