#include "convert.h"
#include "models.h"
#include "point.h"
#include "C12832_lcd.h" 
#include <math.h>

int pow(int x, int y){
    int ans = 1;
    for(int i = 0; i < y; i++){
        ans *= x;
    }
    return ans;   
}

int binary(int bina){
    int ans = 0;
    for (int i = 0; bina>0 ; i++)
    {
        ans = ans+(bina%2)*pow(10,i);
        bina = bina/2;
    }
    return ans;
}

Bitmap Converter::convert(int map[][LCD_X]){
    int len = LCD_Y*LCD_X/CHAR_SIZE;
    int count = 0;
    int tmp = 0;
    char char_map[len];
    for(int i = 0; i < len; i++ ){
        char_map[i] = 0;
    }
    
    for(int i = 0; i < LCD_Y; i++){
        for(int j = 0; j < LCD_X; j++){
            int index = (i*LCD_X + j)/CHAR_SIZE;
            char_map[index] |= map[i][j] << ((CHAR_SIZE - 1) - (i*LCD_X + j) % CHAR_SIZE);   
        }
    }

    //return char_map;
    Bitmap bitmap_converted = {
        LCD_X,
        LCD_Y,
        LCD_X/CHAR_SIZE,
        char_map,
    };
    return bitmap_converted;
}



