#include "mbed.h"
#include "functions.h"
#include "ble_functions.h"

#include "RawSerial.h"
#include "bmi160.h"
#include "max32630fthr.h"
#include "max3263x.h"
#include "MAX14690.h"
#include "ADT7410.h"
#include "Adafruit_SSD1306.h"
//#include "Thermistor.h"
//#include "ds1621.h"

#include <BLE.h>
#include "ble/BLE.h"
#include "ble/Gap.h"

#include "SDBlockDevice.h"
#include "FATFileSystem.h"

#include <errno.h>
#include <stdio.h>
#include <time.h>
#include <stdint.h>
#include <InterruptIn.h>
#include <InterruptManager.h>

//MAX32630FTHR
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

//MAX14690 Wearable Power-Management Solution Driver
I2C i2cm2(I2C2_SDA, I2C2_SCL);
MAX14690 max14690(&i2cm2);

char device_id[10];

int sensor_temp = 1;
unsigned short int measure_id = 0;
unsigned short int log_id = 0;

//SD-Karte
FATFileSystem   fileSystem("fs");
SDBlockDevice   blockDevice(P0_5, P0_6, P0_4, P0_7);  // mosi, miso, sck, cs

//Bluetooth-Modul PAN1326B
RawSerial pan1326b(P0_1, P0_0);     //TX, RX
DigitalOut bt_rst (P1_6);           //Bluetooth reset

//I2C
I2C i2c(P3_4, P3_5); //SDA, SCL

//Temperatursensor
ADT7410 myADT7410(P3_4, P3_5, 0x90, 100000); //SDA, SCL, Address, Hz

//Termistor
//Thermistor extruder(AIN_1);

//DS1621
//#define DS1621_ADDR 0     // I2c DS1621 address is 0x00
//DS1621 ds(&i2c, DS1621_ADDR);  // Declare ds1621 throught i2c interface

//Akku-monitoring
AnalogIn battery(AIN_0);

//USB-monitroing
AnalogIn usb(AIN_5);

//LEDs
DigitalOut r (P2_4);            //Rote LED
DigitalOut g (P2_5);            //Grüne LED
DigitalOut b (P2_6);            //Blaue LED
DigitalOut RGBs[] = {r, g, b};  //LEDs Liste
/*
DigitalOut r (P5_6);            //Rote LED
DigitalOut g (P5_5);            //Grüne LED
DigitalOut b (P5_4);            //Blaue LED
DigitalOut RGBs[] = {r, g, b};  //LEDs Liste
*/
//Button interrupt
InterruptIn button(P2_3, PullUp);   //Auf Pull Up eingestellt
//InterruptIn button(P5_3, PullUp);   //BT
//InterruptIn button2(P3_3, PullUp);   //BT

//I2C OLED
Adafruit_SSD1306_I2c featherOLED(i2c);
/*
//OLED Buttons
InterruptIn aButton(P5_3, PullUp);
InterruptIn bButton(P3_3, PullUp);
InterruptIn cButton(P3_2, PullUp);
*/
Timeout after_BLE;
Timeout led_check;                  //Zum Überprüfen, ob Datenlogger an ist
Timeout turnoff;                    //Zum Auschalten (nicht implementiert)
Timeout flipper;                    //Zum Bluetooth an / aus
Timeout advertise_cancel;           //Zum abbrechen von BT bei keinem Verbindungsaufbau
Timeout connected_cancel;           //Zum abbrechen von BT bei kein Befehlempfang
Ticker mess_timer;                  //ticker eventuell nur bis 30 Minuten geeignet
Ticker ticker;
Ticker charger;

time_t now;     //Zeit Funktionen
time_t raw;

float           buffer_temp;
struct          tm current = {0};   //tm - Zeit im Kalenderformat
struct          tm actual = {0};

volatile int quit = 0;              //BLE Advertise Flag
volatile int conn_state = 0;        //Verbindungsstatus für BLE

bool after_BT = false;
bool in_BT = false;                 //Flag für BLE ist an
bool error_status = false;          //Wenn es ein Fehler beim Initialisierung gab
bool BT_error = false;              //Wenn es BLE oder SD Fehler ist, dann werden die Button Interrupts nicht deklariert
bool shipping = false;              //Sendevorgang Status
bool pause = true;                  //Pause während Sendevorgang
bool init_status = false;           //Erfolgreiche Initialisierung Status
bool charge = false;                //Wenn DL an Stromnetz angeschlossen ist

struct tm user_config_time;        
struct user_config_struct user_config_para = {0, 0, 0, 0, 0, 0, 0}; //Liste für Config Parameter

int next_state = 0;                 //State-Machine

int unsigned long unix_time = 0;    //Zeit in Unix Zeitformat

int default_advertise_time = 300;   //Default Timer für BLE advertising
int default_connected_time = 180;   //Default Timer für BLE verbunden

int alert_count = 0;                //Alarme Zähler

void turnOFF(){
    if(BT_error == false){
        in_BT = false;
        BT_false();
    }
    next_state = 4;
}

void flip(){
    if(BT_error == false){
        in_BT = !in_BT;
        if(in_BT == true){
            BT_true();
        }else if(in_BT == false){
            BT_false();
        }
    }
    turnoff.attach(&turnOFF, 4);     // Button für weitere 4 Sekunden halten um Datenlogger auszuschalten
}

void onCheck(){
    r = 1;
    g = 1;
}

void pushed() 
{
    flipper.attach(&flip, 1);       // Button für eine Sekunde gedrückt halten um BT zu aktivieren
}

void released() {
    if(quit == 0 && charge == false && after_BT == false){
        if(error_status == true){
            r = 0;
        }else if(shipping == true && pause == false){
            r = 0;
            g = 0;
        }else{
            g = 0;
        }
        led_check.attach(&onCheck, 3);
    }
    flipper.detach();
    turnoff.detach();
}

void pre_delay(){
        for(int i = 0; user_config_para.pre_delay > i; i++){
            r = 0;
            g = 0;
            b = 0;
            printf("\nPre-delay: %d of %d seconds\n", i + 1, user_config_para.pre_delay);
            wait_ms(500);
            r = 1;
            g = 1;
            b = 1;
            wait_ms(500);
        }
}

void mess_handler(){
    next_state = 1;
}

void chargeCheck(){
    
}

void states(){
    switch(next_state){
        case 0:
        {/*
            printf("\n\nSleep\n\n");
            while ( next_state == 0 ){
                float batteryProcent = (100 / 0.271) * (battery.read() - 0.704);
                if(usb.read() > 0.8){
                    r = 0;
                    charge = true;
                }else if(usb.read() < 0.2){
                    r = 1;
                    charge = false;
                }
                
                
            }*/
            while ( next_state == 0 ){
                sleep();
                wait(0.1);
            }
            //wait(0.5);
            break;
        }
        case 1:
        {
            get_Messwert();
            next_state = 0;
            break;
        }
        case 2:
        {
            r = 1;
            conn_state = 0;
            quit = 1;
            BLE_handler();
            break;
        }
        case 3:
        {
            pre_delay();
            next_state = 1;
            mess_timer.attach(&mess_handler, (float)user_config_para.interval);   // Mess-Timer attachen
            break;
        }
        case 4:
        {
            b = 0;
            r = 0;
            if(BT_error == false){
                char string[] = "Shutting down Coldchainlogger...";
                write_to_sd_log_single(string);
            }
            printf("\n_______________________________\n\nShutting down Coldchainlogger\n_______________________________\n\n");
            wait(0.5);
            max14690.shutdown();
        }
    }
}

int main() {
    init();
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    
    if(BT_error == true){
        printf("\nBluetooth or SD initialize error: bluetooth can not be used\n");
    }
    
    __enable_irq();
    button.fall(&pushed);
    button.rise(&released);
    
    while(true) {
       /*
       printf("ANALOG: %f\n", battery.read());
       float batteryProcent = (100 / 0.271) * (battery.read() - 0.704);
       printf("PROCENT: %f\n", batteryProcent);
       
       printf("Extruder Temperature %f *C\r\n",extruder.get_temperature()); 
       printf("Sensor Temperature %f *C\r\n",myADT7410.getTemp()); 
       wait(.5); 
       */
       states();
    }
}