#include "mbed.h"
#include "INA219.hpp"

Serial pc(USBTX, USBRX);
DigitalOut led1(p25);

// Get this to work with the INA219 Breakout from Adafruit
INA219 ina219(p28, p27, 0x40, 400000, RES_10BITS);

Ticker measure;
float refresh_rate = 1000;

void show_current()
{
    float current_ma = ina219.read_current_mA();
    pc.printf("%f\r\n", current_ma);
    
    led1 = !led1;
}

int main(void)
{
    pc.baud(921600);

    float refresh_interval = 1/refresh_rate;
    measure.attach(&show_current, refresh_interval);

    while (1) {
    }
}