#ifndef _ROS_SERVICE_ChangeTopic_h
#define _ROS_SERVICE_ChangeTopic_h
#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace jsk_topic_tools
{

static const char CHANGETOPIC[] = "jsk_topic_tools/ChangeTopic";

  class ChangeTopicRequest : public ros::Msg
  {
    public:
      typedef const char* _topic_type;
      _topic_type topic;

    ChangeTopicRequest():
      topic("")
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      uint32_t length_topic = strlen(this->topic);
      varToArr(outbuffer + offset, length_topic);
      offset += 4;
      memcpy(outbuffer + offset, this->topic, length_topic);
      offset += length_topic;
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      uint32_t length_topic;
      arrToVar(length_topic, (inbuffer + offset));
      offset += 4;
      for(unsigned int k= offset; k< offset+length_topic; ++k){
          inbuffer[k-1]=inbuffer[k];
      }
      inbuffer[offset+length_topic-1]=0;
      this->topic = (char *)(inbuffer + offset-1);
      offset += length_topic;
     return offset;
    }

    virtual const char * getType(){ return CHANGETOPIC; };
    virtual const char * getMD5(){ return "d8f94bae31b356b24d0427f80426d0c3"; };

  };

  class ChangeTopicResponse : public ros::Msg
  {
    public:

    ChangeTopicResponse()
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
     return offset;
    }

    virtual const char * getType(){ return CHANGETOPIC; };
    virtual const char * getMD5(){ return "d41d8cd98f00b204e9800998ecf8427e"; };

  };

  class ChangeTopic {
    public:
    typedef ChangeTopicRequest Request;
    typedef ChangeTopicResponse Response;
  };

}
#endif
