#ifndef _ROS_SERVICE_DissocTF_h
#define _ROS_SERVICE_DissocTF_h
#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"
#include "std_msgs/Header.h"

namespace dynamic_tf_publisher
{

static const char DISSOCTF[] = "dynamic_tf_publisher/DissocTF";

  class DissocTFRequest : public ros::Msg
  {
    public:
      typedef std_msgs::Header _header_type;
      _header_type header;
      typedef const char* _frame_id_type;
      _frame_id_type frame_id;

    DissocTFRequest():
      header(),
      frame_id("")
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      offset += this->header.serialize(outbuffer + offset);
      uint32_t length_frame_id = strlen(this->frame_id);
      varToArr(outbuffer + offset, length_frame_id);
      offset += 4;
      memcpy(outbuffer + offset, this->frame_id, length_frame_id);
      offset += length_frame_id;
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      offset += this->header.deserialize(inbuffer + offset);
      uint32_t length_frame_id;
      arrToVar(length_frame_id, (inbuffer + offset));
      offset += 4;
      for(unsigned int k= offset; k< offset+length_frame_id; ++k){
          inbuffer[k-1]=inbuffer[k];
      }
      inbuffer[offset+length_frame_id-1]=0;
      this->frame_id = (char *)(inbuffer + offset-1);
      offset += length_frame_id;
     return offset;
    }

    virtual const char * getType(){ return DISSOCTF; };
    virtual const char * getMD5(){ return "5fa93cf9f65be2325fa0008ddcc90131"; };

  };

  class DissocTFResponse : public ros::Msg
  {
    public:

    DissocTFResponse()
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
     return offset;
    }

    virtual const char * getType(){ return DISSOCTF; };
    virtual const char * getMD5(){ return "d41d8cd98f00b204e9800998ecf8427e"; };

  };

  class DissocTF {
    public:
    typedef DissocTFRequest Request;
    typedef DissocTFResponse Response;
  };

}
#endif
