#ifndef _ROS_catchrobo_msgs_PegInHoleCmd_h
#define _ROS_catchrobo_msgs_PegInHoleCmd_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace catchrobo_msgs
{

  class PegInHoleCmd : public ros::Msg
  {
    public:
      typedef bool _run_type;
      _run_type run;
      typedef float _center_x_type;
      _center_x_type center_x;
      typedef float _center_y_type;
      _center_y_type center_y;

    PegInHoleCmd():
      run(0),
      center_x(0),
      center_y(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      union {
        bool real;
        uint8_t base;
      } u_run;
      u_run.real = this->run;
      *(outbuffer + offset + 0) = (u_run.base >> (8 * 0)) & 0xFF;
      offset += sizeof(this->run);
      union {
        float real;
        uint32_t base;
      } u_center_x;
      u_center_x.real = this->center_x;
      *(outbuffer + offset + 0) = (u_center_x.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_center_x.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_center_x.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_center_x.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->center_x);
      union {
        float real;
        uint32_t base;
      } u_center_y;
      u_center_y.real = this->center_y;
      *(outbuffer + offset + 0) = (u_center_y.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_center_y.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_center_y.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_center_y.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->center_y);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      union {
        bool real;
        uint8_t base;
      } u_run;
      u_run.base = 0;
      u_run.base |= ((uint8_t) (*(inbuffer + offset + 0))) << (8 * 0);
      this->run = u_run.real;
      offset += sizeof(this->run);
      union {
        float real;
        uint32_t base;
      } u_center_x;
      u_center_x.base = 0;
      u_center_x.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_center_x.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_center_x.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_center_x.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->center_x = u_center_x.real;
      offset += sizeof(this->center_x);
      union {
        float real;
        uint32_t base;
      } u_center_y;
      u_center_y.base = 0;
      u_center_y.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_center_y.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_center_y.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_center_y.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->center_y = u_center_y.real;
      offset += sizeof(this->center_y);
     return offset;
    }

    virtual const char * getType(){ return "catchrobo_msgs/PegInHoleCmd"; };
    virtual const char * getMD5(){ return "0dd1ede2ea0ac9ce8042ed6bf7bedb0b"; };

  };

}
#endif
