#ifndef _ROS_catchrobo_msgs_MyRosCmdArray_h
#define _ROS_catchrobo_msgs_MyRosCmdArray_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"
#include "catchrobo_msgs/MyRosCmd.h"

namespace catchrobo_msgs
{

  class MyRosCmdArray : public ros::Msg
  {
    public:
      uint32_t command_array_length;
      typedef catchrobo_msgs::MyRosCmd _command_array_type;
      _command_array_type st_command_array;
      _command_array_type * command_array;

    MyRosCmdArray():
      command_array_length(0), command_array(NULL)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      *(outbuffer + offset + 0) = (this->command_array_length >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (this->command_array_length >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (this->command_array_length >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (this->command_array_length >> (8 * 3)) & 0xFF;
      offset += sizeof(this->command_array_length);
      for( uint32_t i = 0; i < command_array_length; i++){
      offset += this->command_array[i].serialize(outbuffer + offset);
      }
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      uint32_t command_array_lengthT = ((uint32_t) (*(inbuffer + offset))); 
      command_array_lengthT |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1); 
      command_array_lengthT |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2); 
      command_array_lengthT |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3); 
      offset += sizeof(this->command_array_length);
      if(command_array_lengthT > command_array_length)
        this->command_array = (catchrobo_msgs::MyRosCmd*)realloc(this->command_array, command_array_lengthT * sizeof(catchrobo_msgs::MyRosCmd));
      command_array_length = command_array_lengthT;
      for( uint32_t i = 0; i < command_array_length; i++){
      offset += this->st_command_array.deserialize(inbuffer + offset);
        memcpy( &(this->command_array[i]), &(this->st_command_array), sizeof(catchrobo_msgs::MyRosCmd));
      }
     return offset;
    }

    virtual const char * getType(){ return "catchrobo_msgs/MyRosCmdArray"; };
    virtual const char * getMD5(){ return "9cc28e913d9d86366e7efe81e2393470"; };

  };

}
#endif
