#ifndef _ROS_catchrobo_msgs_MyRosCmd_h
#define _ROS_catchrobo_msgs_MyRosCmd_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace catchrobo_msgs
{

  class MyRosCmd : public ros::Msg
  {
    public:
      typedef uint8_t _id_type;
      _id_type id;
      typedef uint8_t _mode_type;
      _mode_type mode;
      typedef float _position_type;
      _position_type position;
      typedef float _velocity_type;
      _velocity_type velocity;
      typedef float _effort_type;
      _effort_type effort;
      typedef float _net_inertia_type;
      _net_inertia_type net_inertia;
      typedef float _position_min_type;
      _position_min_type position_min;
      typedef float _position_max_type;
      _position_max_type position_max;
      typedef float _velocity_limit_type;
      _velocity_limit_type velocity_limit;
      typedef float _acceleration_limit_type;
      _acceleration_limit_type acceleration_limit;
      typedef float _jerk_limit_type;
      _jerk_limit_type jerk_limit;
      typedef float _kp_type;
      _kp_type kp;
      typedef float _kd_type;
      _kd_type kd;
      enum { DIRECT_CTRL_MODE = 0 };
      enum { POSITION_CTRL_MODE = 1 };
      enum { PEG_IN_HOLE_MODE = 2 };
      enum { GO_ORIGIN_MODE = 3 };
      enum { VELOCITY_CTRL_MODE = 4 };

    MyRosCmd():
      id(0),
      mode(0),
      position(0),
      velocity(0),
      effort(0),
      net_inertia(0),
      position_min(0),
      position_max(0),
      velocity_limit(0),
      acceleration_limit(0),
      jerk_limit(0),
      kp(0),
      kd(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      *(outbuffer + offset + 0) = (this->id >> (8 * 0)) & 0xFF;
      offset += sizeof(this->id);
      *(outbuffer + offset + 0) = (this->mode >> (8 * 0)) & 0xFF;
      offset += sizeof(this->mode);
      union {
        float real;
        uint32_t base;
      } u_position;
      u_position.real = this->position;
      *(outbuffer + offset + 0) = (u_position.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_position.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_position.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_position.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->position);
      union {
        float real;
        uint32_t base;
      } u_velocity;
      u_velocity.real = this->velocity;
      *(outbuffer + offset + 0) = (u_velocity.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_velocity.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_velocity.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_velocity.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->velocity);
      union {
        float real;
        uint32_t base;
      } u_effort;
      u_effort.real = this->effort;
      *(outbuffer + offset + 0) = (u_effort.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_effort.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_effort.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_effort.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->effort);
      union {
        float real;
        uint32_t base;
      } u_net_inertia;
      u_net_inertia.real = this->net_inertia;
      *(outbuffer + offset + 0) = (u_net_inertia.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_net_inertia.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_net_inertia.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_net_inertia.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->net_inertia);
      union {
        float real;
        uint32_t base;
      } u_position_min;
      u_position_min.real = this->position_min;
      *(outbuffer + offset + 0) = (u_position_min.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_position_min.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_position_min.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_position_min.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->position_min);
      union {
        float real;
        uint32_t base;
      } u_position_max;
      u_position_max.real = this->position_max;
      *(outbuffer + offset + 0) = (u_position_max.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_position_max.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_position_max.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_position_max.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->position_max);
      union {
        float real;
        uint32_t base;
      } u_velocity_limit;
      u_velocity_limit.real = this->velocity_limit;
      *(outbuffer + offset + 0) = (u_velocity_limit.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_velocity_limit.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_velocity_limit.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_velocity_limit.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->velocity_limit);
      union {
        float real;
        uint32_t base;
      } u_acceleration_limit;
      u_acceleration_limit.real = this->acceleration_limit;
      *(outbuffer + offset + 0) = (u_acceleration_limit.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_acceleration_limit.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_acceleration_limit.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_acceleration_limit.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->acceleration_limit);
      union {
        float real;
        uint32_t base;
      } u_jerk_limit;
      u_jerk_limit.real = this->jerk_limit;
      *(outbuffer + offset + 0) = (u_jerk_limit.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_jerk_limit.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_jerk_limit.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_jerk_limit.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->jerk_limit);
      union {
        float real;
        uint32_t base;
      } u_kp;
      u_kp.real = this->kp;
      *(outbuffer + offset + 0) = (u_kp.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_kp.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_kp.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_kp.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->kp);
      union {
        float real;
        uint32_t base;
      } u_kd;
      u_kd.real = this->kd;
      *(outbuffer + offset + 0) = (u_kd.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_kd.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_kd.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_kd.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->kd);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      this->id =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->id);
      this->mode =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->mode);
      union {
        float real;
        uint32_t base;
      } u_position;
      u_position.base = 0;
      u_position.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_position.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_position.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_position.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->position = u_position.real;
      offset += sizeof(this->position);
      union {
        float real;
        uint32_t base;
      } u_velocity;
      u_velocity.base = 0;
      u_velocity.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_velocity.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_velocity.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_velocity.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->velocity = u_velocity.real;
      offset += sizeof(this->velocity);
      union {
        float real;
        uint32_t base;
      } u_effort;
      u_effort.base = 0;
      u_effort.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_effort.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_effort.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_effort.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->effort = u_effort.real;
      offset += sizeof(this->effort);
      union {
        float real;
        uint32_t base;
      } u_net_inertia;
      u_net_inertia.base = 0;
      u_net_inertia.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_net_inertia.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_net_inertia.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_net_inertia.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->net_inertia = u_net_inertia.real;
      offset += sizeof(this->net_inertia);
      union {
        float real;
        uint32_t base;
      } u_position_min;
      u_position_min.base = 0;
      u_position_min.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_position_min.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_position_min.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_position_min.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->position_min = u_position_min.real;
      offset += sizeof(this->position_min);
      union {
        float real;
        uint32_t base;
      } u_position_max;
      u_position_max.base = 0;
      u_position_max.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_position_max.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_position_max.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_position_max.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->position_max = u_position_max.real;
      offset += sizeof(this->position_max);
      union {
        float real;
        uint32_t base;
      } u_velocity_limit;
      u_velocity_limit.base = 0;
      u_velocity_limit.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_velocity_limit.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_velocity_limit.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_velocity_limit.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->velocity_limit = u_velocity_limit.real;
      offset += sizeof(this->velocity_limit);
      union {
        float real;
        uint32_t base;
      } u_acceleration_limit;
      u_acceleration_limit.base = 0;
      u_acceleration_limit.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_acceleration_limit.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_acceleration_limit.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_acceleration_limit.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->acceleration_limit = u_acceleration_limit.real;
      offset += sizeof(this->acceleration_limit);
      union {
        float real;
        uint32_t base;
      } u_jerk_limit;
      u_jerk_limit.base = 0;
      u_jerk_limit.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_jerk_limit.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_jerk_limit.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_jerk_limit.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->jerk_limit = u_jerk_limit.real;
      offset += sizeof(this->jerk_limit);
      union {
        float real;
        uint32_t base;
      } u_kp;
      u_kp.base = 0;
      u_kp.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_kp.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_kp.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_kp.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->kp = u_kp.real;
      offset += sizeof(this->kp);
      union {
        float real;
        uint32_t base;
      } u_kd;
      u_kd.base = 0;
      u_kd.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_kd.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_kd.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_kd.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->kd = u_kd.real;
      offset += sizeof(this->kd);
     return offset;
    }

    virtual const char * getType(){ return "catchrobo_msgs/MyRosCmd"; };
    virtual const char * getMD5(){ return "6ab164ce9b4b573bf5693e427e5544eb"; };

  };

}
#endif
