#ifndef _ROS_catchrobo_msgs_ErrorCode_h
#define _ROS_catchrobo_msgs_ErrorCode_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace catchrobo_msgs
{

  class ErrorCode : public ros::Msg
  {
    public:
      typedef uint8_t _id_type;
      _id_type id;
      typedef uint8_t _error_code_type;
      _error_code_type error_code;
      enum { NONE = 0 };
      enum { OVER_POSITION = 1 };
      enum { OVER_VELOCITY = 2 };
      enum { OVER_TORQUE = 3 };
      enum { FAR_TARGET_POSITION = 4 };
      enum { COLLISION = 5 };
      enum { FINISH =  6 };

    ErrorCode():
      id(0),
      error_code(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      *(outbuffer + offset + 0) = (this->id >> (8 * 0)) & 0xFF;
      offset += sizeof(this->id);
      *(outbuffer + offset + 0) = (this->error_code >> (8 * 0)) & 0xFF;
      offset += sizeof(this->error_code);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      this->id =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->id);
      this->error_code =  ((uint8_t) (*(inbuffer + offset)));
      offset += sizeof(this->error_code);
     return offset;
    }

    virtual const char * getType(){ return "catchrobo_msgs/ErrorCode"; };
    virtual const char * getMD5(){ return "aceee3091e1a045dee8a6a3039036673"; };

  };

}
#endif
