#ifndef _ROS_catchrobo_msgs_ControlStruct_h
#define _ROS_catchrobo_msgs_ControlStruct_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"

namespace catchrobo_msgs
{

  class ControlStruct : public ros::Msg
  {
    public:
      typedef int32_t _id_type;
      _id_type id;
      typedef double _p_des_type;
      _p_des_type p_des;
      typedef double _v_des_type;
      _v_des_type v_des;
      typedef double _torque_feed_forward_type;
      _torque_feed_forward_type torque_feed_forward;
      typedef double _kp_type;
      _kp_type kp;
      typedef double _kd_type;
      _kd_type kd;

    ControlStruct():
      id(0),
      p_des(0),
      v_des(0),
      torque_feed_forward(0),
      kp(0),
      kd(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      union {
        int32_t real;
        uint32_t base;
      } u_id;
      u_id.real = this->id;
      *(outbuffer + offset + 0) = (u_id.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_id.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_id.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_id.base >> (8 * 3)) & 0xFF;
      offset += sizeof(this->id);
      union {
        double real;
        uint64_t base;
      } u_p_des;
      u_p_des.real = this->p_des;
      *(outbuffer + offset + 0) = (u_p_des.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_p_des.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_p_des.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_p_des.base >> (8 * 3)) & 0xFF;
      *(outbuffer + offset + 4) = (u_p_des.base >> (8 * 4)) & 0xFF;
      *(outbuffer + offset + 5) = (u_p_des.base >> (8 * 5)) & 0xFF;
      *(outbuffer + offset + 6) = (u_p_des.base >> (8 * 6)) & 0xFF;
      *(outbuffer + offset + 7) = (u_p_des.base >> (8 * 7)) & 0xFF;
      offset += sizeof(this->p_des);
      union {
        double real;
        uint64_t base;
      } u_v_des;
      u_v_des.real = this->v_des;
      *(outbuffer + offset + 0) = (u_v_des.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_v_des.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_v_des.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_v_des.base >> (8 * 3)) & 0xFF;
      *(outbuffer + offset + 4) = (u_v_des.base >> (8 * 4)) & 0xFF;
      *(outbuffer + offset + 5) = (u_v_des.base >> (8 * 5)) & 0xFF;
      *(outbuffer + offset + 6) = (u_v_des.base >> (8 * 6)) & 0xFF;
      *(outbuffer + offset + 7) = (u_v_des.base >> (8 * 7)) & 0xFF;
      offset += sizeof(this->v_des);
      union {
        double real;
        uint64_t base;
      } u_torque_feed_forward;
      u_torque_feed_forward.real = this->torque_feed_forward;
      *(outbuffer + offset + 0) = (u_torque_feed_forward.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_torque_feed_forward.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_torque_feed_forward.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_torque_feed_forward.base >> (8 * 3)) & 0xFF;
      *(outbuffer + offset + 4) = (u_torque_feed_forward.base >> (8 * 4)) & 0xFF;
      *(outbuffer + offset + 5) = (u_torque_feed_forward.base >> (8 * 5)) & 0xFF;
      *(outbuffer + offset + 6) = (u_torque_feed_forward.base >> (8 * 6)) & 0xFF;
      *(outbuffer + offset + 7) = (u_torque_feed_forward.base >> (8 * 7)) & 0xFF;
      offset += sizeof(this->torque_feed_forward);
      union {
        double real;
        uint64_t base;
      } u_kp;
      u_kp.real = this->kp;
      *(outbuffer + offset + 0) = (u_kp.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_kp.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_kp.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_kp.base >> (8 * 3)) & 0xFF;
      *(outbuffer + offset + 4) = (u_kp.base >> (8 * 4)) & 0xFF;
      *(outbuffer + offset + 5) = (u_kp.base >> (8 * 5)) & 0xFF;
      *(outbuffer + offset + 6) = (u_kp.base >> (8 * 6)) & 0xFF;
      *(outbuffer + offset + 7) = (u_kp.base >> (8 * 7)) & 0xFF;
      offset += sizeof(this->kp);
      union {
        double real;
        uint64_t base;
      } u_kd;
      u_kd.real = this->kd;
      *(outbuffer + offset + 0) = (u_kd.base >> (8 * 0)) & 0xFF;
      *(outbuffer + offset + 1) = (u_kd.base >> (8 * 1)) & 0xFF;
      *(outbuffer + offset + 2) = (u_kd.base >> (8 * 2)) & 0xFF;
      *(outbuffer + offset + 3) = (u_kd.base >> (8 * 3)) & 0xFF;
      *(outbuffer + offset + 4) = (u_kd.base >> (8 * 4)) & 0xFF;
      *(outbuffer + offset + 5) = (u_kd.base >> (8 * 5)) & 0xFF;
      *(outbuffer + offset + 6) = (u_kd.base >> (8 * 6)) & 0xFF;
      *(outbuffer + offset + 7) = (u_kd.base >> (8 * 7)) & 0xFF;
      offset += sizeof(this->kd);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      union {
        int32_t real;
        uint32_t base;
      } u_id;
      u_id.base = 0;
      u_id.base |= ((uint32_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_id.base |= ((uint32_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_id.base |= ((uint32_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_id.base |= ((uint32_t) (*(inbuffer + offset + 3))) << (8 * 3);
      this->id = u_id.real;
      offset += sizeof(this->id);
      union {
        double real;
        uint64_t base;
      } u_p_des;
      u_p_des.base = 0;
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 3))) << (8 * 3);
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 4))) << (8 * 4);
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 5))) << (8 * 5);
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 6))) << (8 * 6);
      u_p_des.base |= ((uint64_t) (*(inbuffer + offset + 7))) << (8 * 7);
      this->p_des = u_p_des.real;
      offset += sizeof(this->p_des);
      union {
        double real;
        uint64_t base;
      } u_v_des;
      u_v_des.base = 0;
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 3))) << (8 * 3);
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 4))) << (8 * 4);
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 5))) << (8 * 5);
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 6))) << (8 * 6);
      u_v_des.base |= ((uint64_t) (*(inbuffer + offset + 7))) << (8 * 7);
      this->v_des = u_v_des.real;
      offset += sizeof(this->v_des);
      union {
        double real;
        uint64_t base;
      } u_torque_feed_forward;
      u_torque_feed_forward.base = 0;
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 3))) << (8 * 3);
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 4))) << (8 * 4);
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 5))) << (8 * 5);
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 6))) << (8 * 6);
      u_torque_feed_forward.base |= ((uint64_t) (*(inbuffer + offset + 7))) << (8 * 7);
      this->torque_feed_forward = u_torque_feed_forward.real;
      offset += sizeof(this->torque_feed_forward);
      union {
        double real;
        uint64_t base;
      } u_kp;
      u_kp.base = 0;
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 3))) << (8 * 3);
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 4))) << (8 * 4);
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 5))) << (8 * 5);
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 6))) << (8 * 6);
      u_kp.base |= ((uint64_t) (*(inbuffer + offset + 7))) << (8 * 7);
      this->kp = u_kp.real;
      offset += sizeof(this->kp);
      union {
        double real;
        uint64_t base;
      } u_kd;
      u_kd.base = 0;
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 0))) << (8 * 0);
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 1))) << (8 * 1);
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 2))) << (8 * 2);
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 3))) << (8 * 3);
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 4))) << (8 * 4);
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 5))) << (8 * 5);
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 6))) << (8 * 6);
      u_kd.base |= ((uint64_t) (*(inbuffer + offset + 7))) << (8 * 7);
      this->kd = u_kd.real;
      offset += sizeof(this->kd);
     return offset;
    }

    virtual const char * getType(){ return "catchrobo_msgs/ControlStruct"; };
    virtual const char * getMD5(){ return "85eed48bd859421add1590c25dc8235c"; };

  };

}
#endif
