//**************************************************
//
// sb612a.cpp
// 焦電センサー
//
//**************************************************
#include "mbed.h"
#include "sb612a.h"

int pinNum; //各ピン番号用の変数
int pirSensor = 2; //焦電センサを2番ピン
int pushSwitch = 3; //PUSHスイッチを3番ピン

void setup()
{
  //4番ピン～13番ピンをOUTPUTに設定
  for (pinNum = 4; pinNum < 14; pinNum++) {
    pinMode(pinNum, OUTPUT);
  }
  pinNum = 4;  //最初は4番ピンのLEDから点灯

  pinMode(pirSensor, INPUT);
  pinMode(pushSwitch, INPUT_PULLUP);  //内蔵のプルアップ抵抗を有効にしています。
  //焦電センサの出力をトリガーに割り込み信号出力
  attachInterrupt(digitalPinToInterrupt(pirSensor), ledControl, RISING);
}

void loop() {}

//---LEDの点灯---------------------------
void ledControl()
{
  int pirLevel;   //PUSHスイッチの値を格納する変数

  pirLevel = digitalRead(pirSensor);
  if (pirLevel == HIGH) {
    while (1) {
      for (pinNum = 4; pinNum < 13; pinNum++) {
        digitalWrite(pinNum, HIGH);
        delay(2000);
        digitalWrite(pinNum, LOW);
        delay(2000);
      }
      for (pinNum = 13 ; pinNum > 4; pinNum--) {
        digitalWrite(pinNum, HIGH);
        delay(2000);
        digitalWrite(pinNum, LOW);
        delay(2000);
      }

      int switchLevel;  //PUSHスイッチの値を格納する変数

      //スイッチが押されたらループを抜ける
      switchLevel = digitalRead(pushSwitch);
      if (switchLevel == LOW) {
        break;
      }
    }
  }
}

//別のプログラム↓
void setup()
{
pinMode(15, INPUT);
pinMode(16, OUTPUT);
}

void loop()
{
if (digitalRead(7) == HIGH) {
digitalWrite(13, HIGH);
delay(5000);
} else {
digitalWrite(13, LOW);
}
}