#include "mbed.h"
#include "JPEGCamera.h"
#include <stdio.h>
#include <base64.h>

LocalFileSystem local("local");

Serial pc(USBTX,USBRX);
JPEGCamera camera(p9,p10);//TX,RX
Serial xbee(p13,p14);

int main(){
    
    Timer timer;
    timer.start();
    camera.setPictureSize(JPEGCamera::SIZE320x240);

    FILE *fp;
    base64 *bs;
    int c;
    
    for (int i = 0; i < 1; i++) {
        if (camera.isReady()) {
            char filename[32];
            sprintf(filename, "/local/pict%03d.jpg",i);
            printf("Picture: %s ",filename);
            if (camera.takePicture(filename)) {
                while (camera.isProcessing()) {
                    camera.processPicture();
                }
            } else {
                printf("take picture failed\r\n");
            }
        } else {
            printf("camera is not ready\r\n");
        }
    }
    printf("time = %f\n", timer.read());
    
        
    xbee.printf("xbee connected!\r\n");
    bs = new base64();
    bs->Encode("/local/PICT000.jpg","/local/d.txt");
        
        
    if((fp=fopen("/local/d.txt","r"))!=NULL)
    {
        while ((c=fgetc(fp))!=EOF){
            xbee.printf("%c",c);
        }
        fclose(fp);
    }
    return 0;
}
    
