#include "mbed.h"
#include "JPEGCamera.h"

int main() {
    JPEGCamera camera(p9, p10); // TX, RX
    LocalFileSystem local("local");
    Timer timer;
    timer.start();
    camera.setPictureSize(JPEGCamera::SIZE320x240);

    for (int i = 0; i < 1; i++) {
        if (camera.isReady()) {
            char filename[32];
            sprintf(filename, "/local/pict%03d.jpg",i);
            printf("Picture: %s ", filename);
            if (camera.takePicture(filename)) {
                while (camera.isProcessing()) {
                    camera.processPicture();
                }
            } else {
                printf("take picture failed\r\n");
            }
        } else {
            printf("camera is not ready\r\n");
        }
    }
    printf("time = %f\n", timer.read());
}