#include "mbed.h"
// 
InterruptIn button1(p15);
InterruptIn button2(p18);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut flash(LED4);
DigitalIn test(p15);        //ここでピン15からの電圧の値、つまりフォトインタラプタが何か遮るものを検知すればハイの1を返して、
                            //何もないつまりスリットの部分ではローの0を返す。それを変数testに代入している
DigitalIn test2(p18);


int flag;                   //変数flagを整数で型づけする。これがスイッチで、1の間は瞬間は何もしないけど、
                            //スリットの間隔であるπ/4とタイヤの半径70mmつまり一つのスリットを通過するごとに52.5mm加算していく必要があるから
                            //0になった瞬間はこれを総距離に加えるというスイッチの役割をする。
int flag2;
float rightrun;                  //変数runをフロートで型づけする
float leftrun2;

void rise1() {
    led1 = !led1;
}
 
void fall1() {
    led1 = !led1;
}
 
int main() {
    while(1) {                                      //常にtrueとして以下の作業を繰り返す
//      printf("%d\r\n", test.read());              //ピン15から読み込んだtestを読み込んでそれを表示する。だからずーっとだーって0か1が表示される
        if (test.read() == 1 and flag == 0){        //もしtestが1つまり何か障害物があって、かつflagが0つまりスイッチが切れているときは
            flag = 1;                               //この時はスイッチを1に切る。ただ障害物があるかつスイッチが1で切れているときはそのまま
        }
        else if (test.read() == 0 and flag == 1){   //そうじゃなくて今度はとうとうtestが0でスリットの部分になった瞬間なのにスイッチが1で切れているときは
            flag = 0;                               //まずこれでスイッチを0にして入れる。
                                                    //こうすることで同じスリットの中でtestが複数回0を返した時に何回も52.5mmを加算しつづけるということがなくなる
            rightrun += 52.5;                            //総距離runに52.5を加算する
        }
        if (test2.read() == 1 and flag2 == 0){
            flag2 = 1;
        }
        else if (test2.read() == 0 and flag2 == 1){
            flag2 = 0;
            leftrun2 += 52.5;
        }
        printf("%f", rightrun);
        printf("\t%f\r\n", leftrun2);
        if (rightrun > 250){                             //もし総距離が250以上ならば、というのもここの値は暫定値。とりあえずゴール地点が決まればまたその値に修正する
            break;                                  //つまりゴールについたらこのループからぬける
        }
//        wait_us(1);
    }
    printf("%f\r\n", rightrun);                          //最後に総距離runを表示する。下のは少し動作確認で使ったプログラムやから今回にはあまり関係ない
    printf("%f\r\n", leftrun2);
//    button1.rise(&rise1); 
//    button1.fall(&fall1);
//    printf("hello world\r\n");
    
//    while(1) {          
//        flash = !flash;
//        wait(0.25);
//    }
}