#ifndef HMC5883L_H
#define HMC5883L_H

#include "mbed.h"

#define CONFIG_A_REG    0x00
#define CONFIG_B_REG    0x01
#define MODE_REG        0x02
#define OUTPUT_REG      0x03
#define STATUS_REG      0x09
// configuration register a
#define AVG1_SAMPLES    0x00
#define AVG2_SAMPLES    0x20
#define AVG4_SAMPLES    0x80
#define AVG8_SAMPLES    0xC0

#define OUTPUT_RATE_0_75    0x00
#define OUTPUT_RATE_1_5     0x04
#define OUTPUT_RATE_3       0x08
#define OUTPUT_RATE_7_5     0x0C
#define OUTPUT_RATE_15      0x10
#define OUTPUT_RATE_30      0x14
#define OUTPUT_RATE_75      0x18

#define NORMAL_MEASUREMENT  0x00
#define POSITIVE_BIAS       0x01
#define NEGATIVE_BIAS       0x02
// mode register
#define CONTINUOUS_MODE     0x00
#define SINGLE_MODE         0x01
#define IDLE_MODE           0x02
// status register
#define STATUS_LOCK         0x02
#define STATUS_READY        0x01
// Utility
#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795
#endif

#define PI2         (2*M_PI)
#define RAD_TO_DEG  (180.0/M_PI)
#define DEG_TO_RAD  (M_PI/180.0)

class HMC5883L
{

public:
    static const int I2C_ADDRESS = 0x3D;//地磁気センサのアドレス
    HMC5883L(PinName p9, PinName p10);
    HMC5883L(I2C &i2c) : i2c_(i2c) {
        init();
    }
    ~HMC5883L();
    void init();
    void setConfigurationA(char);
    char getConfigurationA();
    void setConfigurationB(char);
    char getConfigurationB();
    void setMode(char);
    char getMode();
    void getXYZ(int16_t raw[3]);
    char getStatus();
    double getHeadingXY();
    double getHeadingXYDeg() {
        return (getHeadingXY() * RAD_TO_DEG);//radianからdegreeへ変換
    }

private:
    I2C &i2c_;
    /**
     * The raw buffer for allocating I2C object in its own without heap memory.
     */
    char i2cRaw[sizeof(I2C)];
};
#endif // HMC5883L