#include "mbed.h"

SPI mySPI(D11, D12, A4); // mosi, miso, sclk
DigitalOut cs(D10);
Serial pc(USBTX, USBRX); // tx, rx
double Vref = 5.0 ;

int main(){ 
        cs=1;
        mySPI.format(8,0); //Setup the spi for 10 bit data, spi mode 0
        mySPI.frequency(1000000); // second edge capture, with a 1MHz clock rate
        
        int n=20;  //size of "n" TBD
        int i;
        double sum_volts;
            
        while (1){
            for(i=0;i<n;i++){
                        cs=0;
            
                        int highByte = mySPI.write(0b01101000); //Send the command to recieve the slave data
                        //pc.printf("highByte: %d ",highByte);
            
                        int lowByte = mySPI.write(0xFF); // send dummy byte to receive the slave data
                        //pc.printf("lowByte: %d ",lowByte);
            
                        int wasteByte = mySPI.write(0x00);
            
                        cs=1;

                        int dataCh0 =  ((highByte << 8) + lowByte) & 0x03FF;
                        double volts = dataCh0*Vref / 1024;
            
                        sum_volts = sum_volts + volts;
            }
        
            double ave_volts = sum_volts / n ;        //get the average to reduce the error range
            pc.printf("CH0 %f V\n",ave_volts);
            
            sum_volts = 0.0;        //initialize

            wait(3);        //TBD
        }
}