/**************************************************************************
/ Bubble Blowing Program
/
/ The program rotates a standard rotation servo motor through 180 degrees
/ until something is detected by the IR sensors. It responds by halting
/ the motor, starting a fan and rotating a second motor through 90 degrees.
/
/**************************************************************************/
#include "mbed.h"
#include "Servo.h"

Serial pc(USBTX, USBRX); // USB serial interface
Servo my_srv(p21); // standard rotation servo
Servo bbl_srv(p22); // standard rotation servo
DigitalIn snsr30(p17); // IR sensor
DigitalIn snsr150(p18); // IR sensor
DigitalOut fan(p23); // hobby fan
#define CR_SCALE 12.0
int main() {
 my_srv.calibrate(0.001,45);
 bbl_srv.calibrate(0.001,45);
 float pos_val=0.0; // variable to hold position values
 float step_size=0.01; // position increment/decrement value

 // set the USB serial interface baud rate
 pc.baud(921600);

 while(1) {

    my_srv.write(pos_val); // write to the standard servo 
    pos_val = pos_val + step_size; // increment/decrement the position
    wait(0.05); // wait for 0.05s between each step
        if (pos_val > 1.0 || pos_val < 0.0) { // if servo exceeds boundaries
            step_size = -step_size; // reverse direction
            pos_val = pos_val + step_size;
            }
        if (snsr30 > 0.1 && snsr150 > 0.1) { // if sensors detect something
            wait(1.0);
            fan = 1;
            bbl_srv.write(0.5);
            wait(1.0);
            bbl_srv.write(0.3);
            wait(2.0);
            }  // turn on the fan, rotate servo 2, repeat
        else {
            fan = 0; // turn off the fan
            }
    }
} 
