/*
 * NfcTag.cpp
 * a library to use NFC Tag
 *
 * Copyright (c) 2014 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : lawliet zou
 * Create Time: March 2014
 * Change Log :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "nfc_tag.h"
/*
void NfcTag::init()
{
    Wire.begin();
}*/

// Class Constructor

NfcTag::NfcTag(PinName sda,PinName scl,uint8_t address,AccessMode mode = USER_MODE): m_I2C(sda, scl)
{      
        if(mode == USER_MODE){
            eeAddr = EEPROM_ADDR_E2_DISABLE<<1;
        }else{
            eeAddr = EEPROM_ADDR_E2_ENABLE<<1;
        }     
  _address = address; // m_I2C Module Address
  
}

NfcTag::~NfcTag()
{

}

void NfcTag::submitPassWd(uint8_t* passWd)
{/*
    Wire.beginTransmission(eeAddr);
    Wire.write(0x09);
    Wire.write(0x00);
*/
 (void) m_I2C.start();
 m_I2C.write(eeAddr);
 m_I2C.write(0x09);
m_I2C.write(0x00);


    for(int i = 0; i < PASSWORD_LENGTH; i++){
       // Wire.write(passWd[i]);
       m_I2C.write(passWd[i]);
       
    }
    //Wire.write(0x09);
    m_I2C.write(0x09);
    
    for(int i = 0; i < PASSWORD_LENGTH; i++){
        //Wire.write(passWd[i]);
        m_I2C.write(passWd[i]);
    }
    //Wire.endTransmission();// stop transmitting 
    m_I2C.stop();
}

void NfcTag::writePassWd(uint8_t* passWd)
{
    /*Wire.beginTransmission(eeAddr);
    Wire.write(0x09);
    Wire.write(0x00);*/
    (void) m_I2C.start();
 m_I2C.write(eeAddr);
 m_I2C.write(0x09);
m_I2C.write(0x00);

    for(int i = 0; i < PASSWORD_LENGTH; i++){
       // Wire.write(passWd[i]);
       m_I2C.write(passWd[i]);
    }
    //Wire.write(0x07);
    m_I2C.write(0x07);
    for(int i = 0; i < PASSWORD_LENGTH; i++){
       // Wire.write(passWd[i]);
       m_I2C.write(passWd[i]);
    }
  //  Wire.endTransmission();    // stop transmitting  
   m_I2C.stop();   
}

void NfcTag::sectorProtectConfig(unsigned int sectorNumber, bool protectEnable, SectorAccessRight accessRight, SectorSelectPassWd passWd)
{
    if(!protectEnable){
        _EEPROM_Write_uint8_t(sectorNumber,0x0);
    }else{
        _EEPROM_Write_uint8_t(sectorNumber,protectEnable|(accessRight<<1)|(passWd<<2));
    }
}

void NfcTag::clearSectorProtect(void)
{
    uint8_t buf[64]={0x0};
    _EEPROM_Write_uint8_ts(0, buf, 64);
}


void NfcTag::sectorWriteSockConfig(unsigned int sectorNumber, bool sockEnable)
{
    unsigned int sectorAddress = SECTOR_SECURITY_STATUS_BASE_ADDR + (sectorNumber/8);
    uint8_t sectorBit = sectorNumber%8;
    uint8_t preStatus = _EEPROM_Read_uint8_t(sectorAddress);
    //bool status = (preStatus|(1<<sectorBit))>>sectorBit;
    bool status = (preStatus>>sectorBit)&0x01;
    if(status != sockEnable){
        if(status == true){
            writeuint8_t(sectorAddress,preStatus&(~(1<<sectorBit)));
        }else{
            writeuint8_t(sectorAddress,preStatus|(1<<sectorBit));
        }
    }
}


uint8_t NfcTag::getDSFID()
{
    return _EEPROM_Read_uint8_t(DSFID_ADDR);
}

uint8_t NfcTag::getAFI()
{
    return _EEPROM_Read_uint8_t(AFI_ADDR);
}

uint16_t NfcTag::getRFU()
{
    uint16_t rfu = 0x00;
    rfu = _EEPROM_Read_uint8_t(RFU_ADDR);
    return (rfu<<8|_EEPROM_Read_uint8_t(RFU_ADDR+1));
}

uint8_t NfcTag::getUID(uint8_t* buf)
{
    _EEPROM_Read_uint8_ts(UID_ADDR,buf,UID_LENGTH);    
    return UID_LENGTH;
}

uint32_t NfcTag::getMemoryVolume()
{
    uint32_t volume = 0x0;
    volume = _EEPROM_Read_uint8_t(MEMORY_VOLUME_ADDR); 
    volume = volume<<8|_EEPROM_Read_uint8_t(MEMORY_VOLUME_ADDR+1);
    volume = volume<<8|_EEPROM_Read_uint8_t(MEMORY_VOLUME_ADDR+2);
    return volume;
}

uint8_t NfcTag::getICNumber()
{
    return _EEPROM_Read_uint8_t(IC_NUMBER_ADDR);   
}

void NfcTag::clearMemory()
{
    for(int i = 0; i < EEPROM_I2C_LENGTH; i++){
        writeuint8_t(i,0x0);
    }
}

void NfcTag::writeuint8_t(unsigned int address, uint8_t data)
{
    _EEPROM_Write_uint8_t(address, data);
}

void NfcTag::writeuint8_ts(unsigned int address, uint8_t* buf, unsigned int len)
{
    _EEPROM_Write_uint8_ts(address, buf, len);
}

uint8_t NfcTag::readuint8_t(unsigned int address)
{
    return _EEPROM_Read_uint8_t(address);
}

void NfcTag::readuint8_ts(unsigned int address, uint8_t* buf, unsigned int len)
{
    _EEPROM_Read_uint8_ts(address, buf, len);
}

void NfcTag::_EEPROM_Write_uint8_t(unsigned int address, uint8_t data)
{
    /*Wire.beginTransmission(eeAddr);
    Wire.write((int)(address >> 8));    // MSB 
    Wire.write((int)(address & 0xFF));// LSB 
    Wire.write(data);   // sends one uint8_t  
    //delay(5);
    Wire.endTransmission(); // stop transmitting  */
        (void) m_I2C.start();
 m_I2C.write(eeAddr);
 m_I2C.write((int)(address >> 8));
m_I2C.write((int)(address & 0xFF));
m_I2C.write(data);
wait_ms(5);
m_I2C.stop();
    
      
}

void NfcTag::_EEPROM_Write_uint8_ts(unsigned int address, uint8_t* buf, unsigned int len)
{
    /*Wire.beginTransmission(eeAddr);
    Wire.write((int)(address >> 8));    // MSB 
    Wire.write((int)(address & 0xFF));// LSB */
          (void) m_I2C.start();
 m_I2C.write(eeAddr);
 m_I2C.write((int)(address >> 8));
m_I2C.write((int)(address & 0xFF));


    
    
    
    
    
    for(int i = 0; i < len; i++){
     // Wire.write(buf[i]); // sends one uint8_t  
     m_I2C.write(buf[i]); // sends one uint8_t  
    }
    //Wire.endTransmission(); // stop transmitting 
    m_I2C.stop();       
}

uint8_t NfcTag::_EEPROM_Read_uint8_t(unsigned int address)
{
    uint8_t rdata = 0x7F;
    /*Wire.beginTransmission(eeAddr); //Device Address
    Wire.write((int)(address >> 8)); // EEPROM_MSB
    Wire.write((int)(address & 0xFF)); // EEPROM_LSB
    Wire.endTransmission();*/
     (void) m_I2C.start();
 m_I2C.write(eeAddr);
 m_I2C.write((int)(address >> 8));
m_I2C.write((int)(address & 0xFF));
m_I2C.stop();
  
   //Wire.beginTransmission(eeAddr);
     (void) m_I2C.start();
   // Wire.requestFrom(eeAddr,1);
  m_I2C.write(eeAddr|1);// request read mode
   
   
    /*if (Wire.available()){
        rdata = Wire.read();
    }*/
    rdata = m_I2C.read(0);// read byte no ack
    //Wire.endTransmission();         // end transmission
    m_I2C.stop();
    return rdata;   
}

unsigned int NfcTag::_EEPROM_Read_uint8_ts(unsigned int address, uint8_t* buf, unsigned int len)
{
    uint8_t rdata = 0x7F;
    /*ire.beginTransmission(eeAddr); //Device Address
    Wire.write((int)(address >> 8)); // EEPROM_MSB
    Wire.write((int)(address & 0xFF)); // EEPROM_LSB
    Wire.endTransmission();*/
     (void) m_I2C.start();
 m_I2C.write(eeAddr);
 m_I2C.write((int)(address >> 8));
m_I2C.write((int)(address & 0xFF));
m_I2C.stop();
  
   /* Wire.beginTransmission(eeAddr);
    Wire.requestFrom(eeAddr,len);*/
   (void) m_I2C.start();
    //Wire.requestFrom(eeAddr,1);
  m_I2C.write(eeAddr|1);// request read mode
    int i = 0;
   // while(Wire.available()){
        while(i<len){
       // buf[i++] = Wire.read();
         buf[i++] = m_I2C.read(1);// read I2C with ack
    }
   // Wire.endTransmission();         // end transmission
   m_I2C.stop();
    return i;   
}