#include "mbed.h"


#define PERIODE 10

DigitalOut myled(LED3);
DigitalOut AvD(PB_0);
DigitalOut AvClD(PB_1);
DigitalOut AvG(PF_0);
DigitalOut AvClG(PF_1);
DigitalOut myled3(LED3);
DigitalOut Buz (PA_8);
Serial pc(USBTX, USBRX); // tx, rx

DigitalIn InClD (PA_1);
DigitalIn InClG (PA_3);
DigitalIn InRoute (PA_5);
DigitalIn InCrois (PA_7);
DigitalIn InBuz (PA_6);
int iClD,iClDOld,iClG,iClGOld,iRoute=1,iRouteOld=1,iCrois,iCroisOld,iBuz,iBuzOld;
int TimCl=0;
bool bStcld=false,bStclg=false,bSroute=false,bScrois=false,bBuz=false,bTim1=false;// state of output
int iState=0,iTim1=0;// 


enum State { ROUTE,CROIS,CLIGN,OFF,OFF1,OFF2,OFF3 };
State Light = OFF3;// startup value as ROUTE beam


int giCommodo;


Ticker tick100ms;

void lect_commodo (void)
{giCommodo=giCommodo |(((!InClD)&0X1)+ ((!InClG)&0X1)<<1+((!InRoute)&0X1)<<2+((!InCrois)&0X1)<<3+((!InBuz)&0X1)<<4);
giCommodo=giCommodo &(((!InClD)&0X1)+ ((!InClG)&0X1)<<1+((!InRoute)&0X1)<<2+((!InCrois)&0X1)<<3+((!InBuz)&0X1)<<4);

 }


void Gest_Event (void) // gestionnaire d evenement global
{iClD=InClD.read();iClG=InClG.read();iRoute=InRoute.read();iCrois=InCrois.read();iBuz=InBuz.read();// read input
    
    
    
    
    if ((iRoute==0) && (iRouteOld==1)) // passage en mode Route
    { bSroute=true;// switch to high beam
    }
    if ((iRoute==1) && (iRouteOld==0)) // sortie mode Route
    { bSroute=false;// switch to high beam
    }
    
    if ((iCrois==0) && (iCroisOld==1)) // passage en mode croisement
      { bScrois=true;// switch to high beam
    }
    if ((iCrois==1) && (iCroisOld==0)) // sortie  en mode croisement
      { bScrois=false;// switch to high beam
    }
    
   /*  if ((iClD==0) && (iClDOld==1)) // cligno D actif
      { bStcld=true;// switch to high beam
    }
    if ((iClD==1) && (iClDOld==0)) // clign D inactift
      { bStcld=false;// switch to high beam
    }
    
     if ((iClG==0) && (iClGOld==1)) // cligno g actif
      { bStclg=true;// switch to high beam
    }
    if ((iClG==1) && (iClGOld==0)) // clign g inactift
      { bStclg=false;// switch to high beam
    }
*/
 if ((iBuz==0) && (iBuzOld==1)) // buzzer actif
      { bBuz=true;// switch to high beam
    }
   /* if ((iBuz==1) && (iBuzOld==0)) // buzzer inactift
      { bBuz=false;// switch to high beam
    }*/
    
    if (iTim1>0){iTim1-- ; bTim1=true;}
    else bTim1=false;
    
    
    // update old event value for next time
    iBuzOld=iBuz;
    iClGOld=iClG;
    iClDOld=iClD;
    iCroisOld=iCrois;
    iRouteOld=iRoute;
}

void init_gene(void)
{Buz=0;
     AvD=0;// front beam OFF
AvClD=0;
AvG=0;// front beam OFF
    AvClG=0;
    
    }



void Tick100ms_(void)
{
    
   // iClD=InClD.read();iClG=InClG.read();iRoute=InRoute.read();iCrois=InCrois.read();iBuz=InBuz.read();
   Gest_Event();// call event manager
   
   
   
   
   
            switch (iState)
        {
             case OFF3:
            AvD=0;AvG=0;// front beam off
            if (bSroute==true )
            {  iState=ROUTE; 
            }
         
         
         
         /*   else{if (bRoute==true) &&(bTim1==true))
                { iState=CLIGN; iTim1=30*PERIODE;}*/
             break;
            
            case ROUTE:
            AvD=1;AvG=1;// front beam on
            if (bSroute==false)
            { iTim1=(int) 30*PERIODE;
            iState=OFF1; }
            break;
            
             case OFF1:
             AvD=0;AvG=0;// front beam off
            if ((bSroute==true) &&(bTim1==true))
            {  iState=CROIS; }
            if ((bSroute==true) &&(bTim1==false))
            {iState=ROUTE;}
            
             case CROIS:
             AvD=1;AvG=1;// front beam on
            if (bSroute==false)
            { iState=OFF2; 
            iTim1=30*PERIODE;}
                        
            break;
            
             case OFF2:
             AvD=0;AvG=0;// front beam off
            if ((bSroute==true) &&(bTim1==false))
            {  iState=ROUTE; }
            if ((bSroute==true) &&(bTim1==true))
            {iState=CLIGN;}
            break;
            
             case CLIGN:
             AvD=1;AvG=1;// front beam on
            if (bSroute==false)
            { iState=OFF3;
            iTim1=30*PERIODE; }
                        
            break;
            
                   
        }
        
     if (iBuz==0)// commande klaxon
     Buz=1;
     else Buz=0;
   
   
   
    // allumage clignotant
    if (TimCl==4)// 0.5s elapsed
    {TimCl=0;
        // clignotant droit
        if (iClD==0) // clid d actif
            if (bStcld==false) //cld off
            {bStcld=true; AvClD=1;}
            else
            {bStcld=false; AvClD=0;}
         else
         { bStcld=false; AvClD=0;}//   
          // clignotant gauche
         if (iClG==0) // clig d actif
            if (bStclg==false) //cld off
            {bStclg=true; AvClG=1;}
            else
            {bStclg=false; AvClG=0;}
         else
         { bStclg=false; AvClG=0;}//    
         
         
         
         
        }
        else TimCl++;
      
       
       
    
    
    }


int main() {
    
    
    char cChoix;
    tick100ms.attach(&Tick100ms_,(1/(float)PERIODE)); // main ticker 100ms 
    init_gene();
    
    
       while(cChoix!='q' and cChoix!='Q')
{pc.printf(" veuillez saisir un choix parmi la liste proposee: \n");
 pc.printf("a: on/off avD \n");
  pc.printf("b: on/off avG \n");
   pc.printf("c: on/off ClavD \n");
  pc.printf("d: on/off ClAvG   \n");
    pc.printf("e: on/off Buz   \n");
    pc.printf("f: lecture commodo   \n");
 pc.printf(" q:quitter \n");
 
 /************* multithreading : main thread need to sleep in order to allow web response */
 while (pc.readable()==0) // determine if char availabler
 {//Thread::wait(10);
  wait_ms(10);
 
 } // wait 10 until char available on serial input

 /************* end of main thread sleep  ****************/ 
 
 pc.scanf(" %c",&cChoix);
 switch (cChoix){
     case 'a': 
     AvD=!AvD;
     break;
     case 'b': 
     AvG=!AvG;
     break;
     case 'c': 
     AvClD=!AvClD;
     break;
     case 'd': 
     AvClG=!AvClG;
     break;
     
     case 'e': 
     Buz=!Buz;
     break;
       case 'f': 
    lect_commodo ();
   // pc.printf(" commodo=%2X \n",giCommodo);
   pc.printf ("clD:%d lcG:%d Rou:%d Crois%d Buz:%d \n",InClD.read(),InClG.read(),InRoute.read(),InCrois.read(),InBuz.read());
     break;
     
     case 'q': 
     break;
     }
} // end while
       
       
       
   } 
    
    
