#include "TextField.h"


TextField::TextField() {
        }
        
void TextField::setDisplay(ILI9341_t3 *pNewTft)
{
    pTft = pNewTft;
}

void TextField::setupField(ILI9341_t3 *pNewTft, const char* buf)
{
    pTft = pNewTft;
    pTft->getCursor(&x, &y);
    w = pTft->strPixelLen(buf);
    pTft->printf("\n");
    h = pTft->getCursorY() - y;
    pTft->setCursor(x+w, y);
}

void TextField::setFieldInt(ILI9341_t3 *pNewTft, const char* fmt, int32_t data)
{
    char buf[64];
    sprintf(buf, fmt, data);
    this->fmt = fmt;
    setupField(pNewTft, &buf[0]);
}

void TextField::setFieldStr(ILI9341_t3 *pNewTft, const char* fmt, const char* data)
{
    char buf[64];
    sprintf(buf, fmt, data);
    this->fmt = fmt;
    setupField(pNewTft, &buf[0]);
};


void TextField::setFieldFloat(ILI9341_t3 *pNewTft, const char* fmt, float data)
{
    char buf[64];
    sprintf(buf, fmt, data);
    this->fmt = fmt;
    setupField(pNewTft, buf);
}


void TextField::setFieldLine(ILI9341_t3 *pNewTft, const char* fmt)
{
    char buf[] = { '\x00' };
    this->fmt = fmt;
    setupField(pNewTft, buf);
    w = pTft->width() - pTft->getCursorX();
}


/* erase the text area of the field */
void TextField::eraseField(bool erase)
{
    if (erase)
        pTft->fillRect(x, y, w, h, ILI9341_BLACK);    
    pTft->setCursor(x, y);

}
    
void TextField::drawFieldInt(int32_t data)
{
    eraseField();
    pTft->printf(fmt, data);
}

void TextField::drawFieldStr(const char* data, bool erase)
{
    eraseField(erase);
    pTft->printf(fmt, data);
}


void TextField::drawFieldFloat(float data)
{
    eraseField();
    pTft->printf(fmt, data);
}
