#ifndef _TEXTFIELD_INC_
#define _TEXTFIELD_INC_

#include "ILI9341_t3.h"

class TextField {

  public:
    TextField();
        
    void setDisplay(ILI9341_t3 *pNewTft);
    void setFieldInt(ILI9341_t3 *pNewTft, const char* fmt, int32_t data);
    void setFieldStr(ILI9341_t3 *pNewTft, const char* fmt, const char* data);
    void setFieldFloat(ILI9341_t3 *pNewTft, const char* fmt, float data);

    void setFieldLine(ILI9341_t3 *pNewTft, const char* fmt);


    void drawFieldInt(int32_t data);
    void drawFieldStr(const char* data, bool erase);
    void drawFieldFloat(float data);

  protected:
    void setupField(ILI9341_t3 *pNewTft, const char* buf);
    void eraseField(bool erase=true);
 
  private:
    ILI9341_t3 *pTft;
    int16_t x, y, w, h;
    const char* fmt;
};

#endif