#include "aws_iot_config.h"
//#define PEMFORMAT
#define CARDFORMAT

#ifdef PEMFORMAT

// The user needs to paste the AWS 'thing' certs into this file.
// Root CA: 
// https://www.symantec.com/content/en/us/enterprise/verisign/roots/VeriSign-Class%203-Public-Primary-Certification-Authority-G5.pem
const unsigned char AWS_IOT_ROOT_CA[] = "-----BEGIN CERTIFICATE-----\n"
"MIIE0zCCA7ugAwIBAgIQGNrRniZ96LtKIVjNzGs7SjANBgkqhkiG9w0BAQUFADCB\n"
"yjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\n"
"ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJp\n"
"U2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW\n"
"ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0\n"
"aG9yaXR5IC0gRzUwHhcNMDYxMTA4MDAwMDAwWhcNMzYwNzE2MjM1OTU5WjCByjEL\n"
"MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZW\n"
"ZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJpU2ln\n"
"biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxWZXJp\n"
"U2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9y\n"
"aXR5IC0gRzUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvJAgIKXo1\n"
"nmAMqudLO07cfLw8RRy7K+D+KQL5VwijZIUVJ/XxrcgxiV0i6CqqpkKzj/i5Vbex\n"
"t0uz/o9+B1fs70PbZmIVYc9gDaTY3vjgw2IIPVQT60nKWVSFJuUrjxuf6/WhkcIz\n"
"SdhDY2pSS9KP6HBRTdGJaXvHcPaz3BJ023tdS1bTlr8Vd6Gw9KIl8q8ckmcY5fQG\n"
"BO+QueQA5N06tRn/Arr0PO7gi+s3i+z016zy9vA9r911kTMZHRxAy3QkGSGT2RT+\n"
"rCpSx4/VBEnkjWNHiDxpg8v+R70rfk/Fla4OndTRQ8Bnc+MUCH7lP59zuDMKz10/\n"
"NIeWiu5T6CUVAgMBAAGjgbIwga8wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8E\n"
"BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJaW1hZ2UvZ2lmMCEwHzAH\n"
"BgUrDgMCGgQUj+XTGoasjY5rw8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVy\n"
"aXNpZ24uY29tL3ZzbG9nby5naWYwHQYDVR0OBBYEFH/TZafC3ey78DAJ80M5+gKv\n"
"MzEzMA0GCSqGSIb3DQEBBQUAA4IBAQCTJEowX2LP2BqYLz3q3JktvXf2pXkiOOzE\n"
"p6B4Eq1iDkVwZMXnl2YtmAl+X6/WzChl8gGqCBpH3vn5fJJaCGkgDdk+bW48DW7Y\n"
"5gaRQBi5+MHt39tBquCWIMnNZBU4gcmU7qKEKQsTb47bDN0lAtukixlE0kF6BWlK\n"
"WE9gyn6CagsCqiUXObXbf+eEZSqVir2G3l6BFoMtEMze/aiCKm0oHw0LxOXnGiYZ\n"
"4fQRbxC1lfznQgUy286dUV4otp6F01vvpX1FQHKOtw5rDgb7MzVIcbidJ4vEZV8N\n"
"hnacRHr2lVz2XTIIM6RUthg/aFzyQkqFOFSDX9HoLPKsEdao7WNq\n"
"-----END CERTIFICATE-----\0";



// Device signed certificate (see AWS_IOT_ROOT_CA for format)
//"MIIDWjCCAkKgAwIBAgIVAJJcu7y+bIT7+WczP+/xVVw6NHn9MA0GCSqGSIb3DQEB\n"
/*
const unsigned char AWS_IOT_CERTIFICATE[] = "-----BEGIN CERTIFICATE-----\n"
"MIIDWjCCAkKgAwIBAgIVAJJcu7y+bIT7+WczP+/xVVw6NHn9MA0GCSqGSIb3DQEB\n"
"CwUAME0xSzBJBgNVBAsMQkFtYXpvbiBXZWIgU2VydmljZXMgTz1BbWF6b24uY29t\n"
"IEluYy4gTD1TZWF0dGxlIFNUPVdhc2hpbmd0b24gQz1VUzAeFw0xNzA4MjUxMzU3\n"
"MjZaFw00OTEyMzEyMzU5NTlaMB4xHDAaBgNVBAMME0FXUyBJb1QgQ2VydGlmaWNh\n"
"dGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC5z26EhlKJGZtKA5qC\n"
"YZFO97oPrFOGNEnu459EKrZY9Z1GFNfHGix8Vj2/HalPGuASIWoTi3Q9I9NHlzdF\n"
"8XHVe10g7r8EYkWMOtJlmExc9TmQBCMcm5wPu1v53dzSq8NLxkjP4Rwu8FrGcVL5\n"
"z5Bv0amJH89sQ81JmF044/mRQ9asC8D+Ep7rCzoGPy1CB1v3UB/+HcgunmTKHP8o\n"
"Y7R1KgDbV/DUa7GDRI1K1iRIFlzk7KGk2G2zXWARP8G6g2VM1nKJvTdYShYh2Cot\n"
"2agy66X9y9W41hn6y+6lqtcFOXZmV4eBxF5RCyiWiRs+BHY0dtiX57MWthmoGgA+\n"
"rHI1AgMBAAGjYDBeMB8GA1UdIwQYMBaAFNTRJGHn65LSprjnJ40z+OfUpSMVMB0G\n"
"A1UdDgQWBBTapjtaKrx+X51xVCgB51+Bf7Zh2jAMBgNVHRMBAf8EAjAAMA4GA1Ud\n"
"DwEB/wQEAwIHgDANBgkqhkiG9w0BAQsFAAOCAQEAFnDh9bYZKFr5v+PWmR0lM9fY\n"
"yTTWdsH+ezbHYAuP0AP6eCrfCxGbl7kNSsdjo2IOOcbVU4m7ijIUZV3+KQgNjmLD\n"
"ETLycn37QNGvzEqL+qEA3j1ZRcVGzD4Qx/xzndrCYTsYj1P4jlW0dl8Ye1RuiKhX\n"
"JEDxtUAqHfazgmfZ6CpBeC2D0x6sAuPq0sVPzmAVulvWuRSomEkN3kpOhY0VoTdm\n"
"MltbXuZcsw5EPGRtx98OD9Zp+x4Av1n3DtQhwRFASld9FuIoeXliHNaqtpaIS4Hb\n"
"00CHGRBIOlF6ur7lOASOku8GoP6XdoGxBRh94Ua+lke3Avl2t69wU7zKTj3uCw==\n"
"-----END CERTIFICATE-----\0";
*/
const unsigned char AWS_IOT_CERTIFICATE[] = "-----BEGIN CERTIFICATE-----\n"
"MIIBpDCCAUkCCQCZBxROIBl2LDAKBggqhkjOPQQDAjCBhzELMAkGA1UEBhMCVVMx\n"
"CzAJBgNVBAgMAlZBMQ8wDQYDVQQHDAZEdWxsZXMxDzANBgNVBAoMBkdETVNBSTEL\n"
"MAkGA1UECwwCTVMxFTATBgNVBAMMDEVyaWMgSm9obnNvbjElMCMGCSqGSIb3DQEJ\n"
"ARYWZXJpYy5qb2huc29uQGdpLWRlLmNvbTAeFw0xNzEwMTMwMDUzMzlaFw0xODEw\n"
"MTMwMDUzMzlaMCsxKTAnBgNVBAMMIDg5MDExNzAyMjc4MTI0MTY1MjQ2QGlvdC5h\n"
"dHQuY29tMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEUB6Du5iIf+TZeG4/XnFc\n"
"ky6WLF0ArrfEUfc5zRDmvg/swQaTcLUFBPkimEv/hbpUs6czW5MXZ6/MyF5eTopj\n"
"pzAKBggqhkjOPQQDAgNJADBGAiEA673SIXvrYUwELGPyP7Ws82CzJ7QMCjI/RtYN\n"
"HfRm/tICIQDpO2Pq82nnN2FcdPyyjENOqCOSj/nwVQePWde0a9+Xqw==\n"
"-----END CERTIFICATE-----\0";

// Device private key (see AWS_IOT_ROOT_CA for format)
/*
const unsigned char AWS_IOT_PRIVATE_KEY[] = "-----BEGIN RSA PRIVATE KEY-----\n"
"MIIEowIBAAKCAQEAuc9uhIZSiRmbSgOagmGRTve6D6xThjRJ7uOfRCq2WPWdRhTX\n"
"xxosfFY9vx2pTxrgEiFqE4t0PSPTR5c3RfFx1XtdIO6/BGJFjDrSZZhMXPU5kAQj\n"
"HJucD7tb+d3c0qvDS8ZIz+EcLvBaxnFS+c+Qb9GpiR/PbEPNSZhdOOP5kUPWrAvA\n"
"/hKe6ws6Bj8tQgdb91Af/h3ILp5kyhz/KGO0dSoA21fw1Guxg0SNStYkSBZc5Oyh\n"
"pNhts11gET/BuoNlTNZyib03WEoWIdgqLdmoMuul/cvVuNYZ+svuparXBTl2ZleH\n"
"gcReUQsolokbPgR2NHbYl+ezFrYZqBoAPqxyNQIDAQABAoIBAAyOnSxtm3RSe7Ej\n"
"zzRSfax1h2h5v+dI71oqnd/QdyRJ7QgIbpCxDyKT/XZF/eQvr8bp5S5O9VsQab3j\n"
"1UNvzr6bqK6KE/Sq44JXk1J0WWzK0coOzYSoa4KQqeWX/c1q+DbNvqv1zZ7KdYgF\n"
"rpLdWSiFZcyzjqQFbQE1P8+RcJNFgecZJLLyQjFXe4bQ1SDeIiTS5NRgY+1ciiQn\n"
"fMIFYtM2/NyD8+CMV/0rMfXa7r/7/KXUSpL2s/aT2XHyDu+Y0AJckohs5ToPwbl6\n"
"vNe8xvgKY9o6CTt8gA6nQbp+8rzW5sFUVCKVWsaWbUZ04j+rkWQR6HVuK9udXWy1\n"
"xs4WNiECgYEA3usI6DWjjy4BcuLfAe0buiLYKXPbcwPXSNjuIxOzkkE9Lgfv5dat\n"
"ZGd29wFxY2wjqj/MCNMfUh/tq1LJaGPsDGQdmeXQNf+DioGj8AwCxTCngx/J6L2Y\n"
"YhgxZuJyoqPNZJPxLvm0a5qnX6Jbj6wPv3uIL5poiU1WNnLMfYkh7NkCgYEA1WKe\n"
"ocBYG0OPP2ePVoa6yi1sBK+HJ+xiN7RITBHKJyOUCXnxAh5jWXLIYKUDnOluTB3v\n"
"RP5Fgp5fHaoWWT4ZIgvGB+vrwPWITmaqWnkkApQigJWltPEy/mSx+bPOLzDVHgEn\n"
"5OCG8HYpTGZTTmKDEuC9YhtX5lhrNtd6+Fd/hr0CgYEAuC7QRDSVeGbVsZv8EHZd\n"
"k3TYz583cZd52GnMkNTlaPFYYGEUeP3gc/X82GerzS77ZN6jcaMm3M8eq5CScxsk\n"
"XLSXtKGqYANHJzioQF1cKJtjvLaWOCP29Q3yO4TcnL7kpLaL73lH9iRpKF5YcqQC\n"
"uv6RbmuQ9ekdU42UoiCdFDkCgYAne03ao9opgUCZ/LFa0ybwjaL04v1g963cnLDb\n"
"0lbTExQrBLMBL1o2jLRinWWjvNU5pDhHTbzSxDbZKEVmUcUYtZD4mkBOvZ9w0jIm\n"
"908gYwRXQlkct5w10a/Ugd5egOyN1qzo/lo5V8OgbTZwxG14Krkf0+tZpXaA+TG5\n"
"jYb9CQKBgESWrztoLhzzyEQiaTpRSulTEm5/QNMhXkLETZR8gRhK8w2/fITUnlDj\n"
"OWnUsCtpJIbesNdFjc20+z0PSfgHamqIQGbgY4rFvATXA0bJs0bhGOzptisjLa2u\n"
"fddOwsIdxkViusil2aXED1lLxiDBGnWvho+F4VNv+z4iuZPcnD16\n"
"-----END RSA PRIVATE KEY-----\0";
*/
const unsigned char AWS_IOT_PRIVATE_KEY[] = "-----BEGIN EC PARAMETERS-----\n"
"BggqhkjOPQMBBw==\n"
"-----END EC PARAMETERS-----\n"
"-----BEGIN EC PRIVATE KEY-----\n"
"MHcCAQEEIMxNzfnS8iENvp4L7G6cA2xA6TTzl+PEHDMKcV7gtwiVoAoGCCqGSM49\n"
"AwEHoUQDQgAEUB6Du5iIf+TZeG4/XnFcky6WLF0ArrfEUfc5zRDmvg/swQaTcLUF\n"
"BPkimEv/hbpUs6czW5MXZ6/MyF5eTopjpw==\n"
"-----END EC PRIVATE KEY-----\0";


#endif

#ifdef DERFORMAT

const unsigned char AWS_IOT_ROOT_CA[] = {0x30, 0x82, 0x04, 0xD3, 0x30, 0x82, 0x03, 0xBB, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 0x18, 
0xDA, 0xD1, 0x9E, 0x26, 0x7D, 0xE8, 0xBB, 0x4A, 0x21, 0x58, 0xCD, 0xCC, 0x6B, 0x3B, 0x4A, 0x30, 
0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x81, 
0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17, 
0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 
0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 
0x13, 0x16, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 
0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38, 0x06, 0x03, 0x55, 0x04, 
0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x36, 0x20, 0x56, 0x65, 0x72, 0x69, 
0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 
0x20, 0x61, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 
0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C, 0x56, 
0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C, 0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 
0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 
0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 
0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x35, 0x30, 0x1E, 0x17, 0x0D, 0x30, 
0x36, 0x31, 0x31, 0x30, 0x38, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5A, 0x17, 0x0D, 0x33, 0x36, 
0x30, 0x37, 0x31, 0x36, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5A, 0x30, 0x81, 0xCA, 0x31, 0x0B, 
0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 
0x03, 0x55, 0x04, 0x0A, 0x13, 0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 
0x49, 0x6E, 0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x56, 
0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 
0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 
0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x36, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 
0x6E, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75, 
0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x6F, 0x6E, 0x6C, 
0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 
0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C, 0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 
0x6C, 0x69, 0x63, 0x20, 0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 
0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 
0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x35, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 
0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 
0x30, 0x82, 0x01, 0x0A, 0x02, 0x82, 0x01, 0x01, 0x00, 0xAF, 0x24, 0x08, 0x08, 0x29, 0x7A, 0x35, 
0x9E, 0x60, 0x0C, 0xAA, 0xE7, 0x4B, 0x3B, 0x4E, 0xDC, 0x7C, 0xBC, 0x3C, 0x45, 0x1C, 0xBB, 0x2B, 
0xE0, 0xFE, 0x29, 0x02, 0xF9, 0x57, 0x08, 0xA3, 0x64, 0x85, 0x15, 0x27, 0xF5, 0xF1, 0xAD, 0xC8, 
0x31, 0x89, 0x5D, 0x22, 0xE8, 0x2A, 0xAA, 0xA6, 0x42, 0xB3, 0x8F, 0xF8, 0xB9, 0x55, 0xB7, 0xB1, 
0xB7, 0x4B, 0xB3, 0xFE, 0x8F, 0x7E, 0x07, 0x57, 0xEC, 0xEF, 0x43, 0xDB, 0x66, 0x62, 0x15, 0x61, 
0xCF, 0x60, 0x0D, 0xA4, 0xD8, 0xDE, 0xF8, 0xE0, 0xC3, 0x62, 0x08, 0x3D, 0x54, 0x13, 0xEB, 0x49, 
0xCA, 0x59, 0x54, 0x85, 0x26, 0xE5, 0x2B, 0x8F, 0x1B, 0x9F, 0xEB, 0xF5, 0xA1, 0x91, 0xC2, 0x33, 
0x49, 0xD8, 0x43, 0x63, 0x6A, 0x52, 0x4B, 0xD2, 0x8F, 0xE8, 0x70, 0x51, 0x4D, 0xD1, 0x89, 0x69, 
0x7B, 0xC7, 0x70, 0xF6, 0xB3, 0xDC, 0x12, 0x74, 0xDB, 0x7B, 0x5D, 0x4B, 0x56, 0xD3, 0x96, 0xBF, 
0x15, 0x77, 0xA1, 0xB0, 0xF4, 0xA2, 0x25, 0xF2, 0xAF, 0x1C, 0x92, 0x67, 0x18, 0xE5, 0xF4, 0x06, 
0x04, 0xEF, 0x90, 0xB9, 0xE4, 0x00, 0xE4, 0xDD, 0x3A, 0xB5, 0x19, 0xFF, 0x02, 0xBA, 0xF4, 0x3C, 
0xEE, 0xE0, 0x8B, 0xEB, 0x37, 0x8B, 0xEC, 0xF4, 0xD7, 0xAC, 0xF2, 0xF6, 0xF0, 0x3D, 0xAF, 0xDD, 
0x75, 0x91, 0x33, 0x19, 0x1D, 0x1C, 0x40, 0xCB, 0x74, 0x24, 0x19, 0x21, 0x93, 0xD9, 0x14, 0xFE, 
0xAC, 0x2A, 0x52, 0xC7, 0x8F, 0xD5, 0x04, 0x49, 0xE4, 0x8D, 0x63, 0x47, 0x88, 0x3C, 0x69, 0x83, 
0xCB, 0xFE, 0x47, 0xBD, 0x2B, 0x7E, 0x4F, 0xC5, 0x95, 0xAE, 0x0E, 0x9D, 0xD4, 0xD1, 0x43, 0xC0, 
0x67, 0x73, 0xE3, 0x14, 0x08, 0x7E, 0xE5, 0x3F, 0x9F, 0x73, 0xB8, 0x33, 0x0A, 0xCF, 0x5D, 0x3F, 
0x34, 0x87, 0x96, 0x8A, 0xEE, 0x53, 0xE8, 0x25, 0x15, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x81, 
0xB2, 0x30, 0x81, 0xAF, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 0x05, 
0x30, 0x03, 0x01, 0x01, 0xFF, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x01, 0x01, 0xFF, 0x04, 
0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x6D, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x01, 
0x0C, 0x04, 0x61, 0x30, 0x5F, 0xA1, 0x5D, 0xA0, 0x5B, 0x30, 0x59, 0x30, 0x57, 0x30, 0x55, 0x16, 
0x09, 0x69, 0x6D, 0x61, 0x67, 0x65, 0x2F, 0x67, 0x69, 0x66, 0x30, 0x21, 0x30, 0x1F, 0x30, 0x07, 
0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0x8F, 0xE5, 0xD3, 0x1A, 0x86, 0xAC, 0x8D, 
0x8E, 0x6B, 0xC3, 0xCF, 0x80, 0x6A, 0xD4, 0x48, 0x18, 0x2C, 0x7B, 0x19, 0x2E, 0x30, 0x25, 0x16, 
0x23, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6C, 0x6F, 0x67, 0x6F, 0x2E, 0x76, 0x65, 0x72, 
0x69, 0x73, 0x69, 0x67, 0x6E, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x76, 0x73, 0x6C, 0x6F, 0x67, 0x6F, 
0x2E, 0x67, 0x69, 0x66, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0x7F, 
0xD3, 0x65, 0xA7, 0xC2, 0xDD, 0xEC, 0xBB, 0xF0, 0x30, 0x09, 0xF3, 0x43, 0x39, 0xFA, 0x02, 0xAF, 
0x33, 0x31, 0x33, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 
0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x93, 0x24, 0x4A, 0x30, 0x5F, 0x62, 0xCF, 0xD8, 0x1A, 
0x98, 0x2F, 0x3D, 0xEA, 0xDC, 0x99, 0x2D, 0xBD, 0x77, 0xF6, 0xA5, 0x79, 0x22, 0x38, 0xEC, 0xC4, 
0xA7, 0xA0, 0x78, 0x12, 0xAD, 0x62, 0x0E, 0x45, 0x70, 0x64, 0xC5, 0xE7, 0x97, 0x66, 0x2D, 0x98, 
0x09, 0x7E, 0x5F, 0xAF, 0xD6, 0xCC, 0x28, 0x65, 0xF2, 0x01, 0xAA, 0x08, 0x1A, 0x47, 0xDE, 0xF9, 
0xF9, 0x7C, 0x92, 0x5A, 0x08, 0x69, 0x20, 0x0D, 0xD9, 0x3E, 0x6D, 0x6E, 0x3C, 0x0D, 0x6E, 0xD8, 
0xE6, 0x06, 0x91, 0x40, 0x18, 0xB9, 0xF8, 0xC1, 0xED, 0xDF, 0xDB, 0x41, 0xAA, 0xE0, 0x96, 0x20, 
0xC9, 0xCD, 0x64, 0x15, 0x38, 0x81, 0xC9, 0x94, 0xEE, 0xA2, 0x84, 0x29, 0x0B, 0x13, 0x6F, 0x8E, 
0xDB, 0x0C, 0xDD, 0x25, 0x02, 0xDB, 0xA4, 0x8B, 0x19, 0x44, 0xD2, 0x41, 0x7A, 0x05, 0x69, 0x4A, 
0x58, 0x4F, 0x60, 0xCA, 0x7E, 0x82, 0x6A, 0x0B, 0x02, 0xAA, 0x25, 0x17, 0x39, 0xB5, 0xDB, 0x7F, 
0xE7, 0x84, 0x65, 0x2A, 0x95, 0x8A, 0xBD, 0x86, 0xDE, 0x5E, 0x81, 0x16, 0x83, 0x2D, 0x10, 0xCC, 
0xDE, 0xFD, 0xA8, 0x82, 0x2A, 0x6D, 0x28, 0x1F, 0x0D, 0x0B, 0xC4, 0xE5, 0xE7, 0x1A, 0x26, 0x19, 
0xE1, 0xF4, 0x11, 0x6F, 0x10, 0xB5, 0x95, 0xFC, 0xE7, 0x42, 0x05, 0x32, 0xDB, 0xCE, 0x9D, 0x51, 
0x5E, 0x28, 0xB6, 0x9E, 0x85, 0xD3, 0x5B, 0xEF, 0xA5, 0x7D, 0x45, 0x40, 0x72, 0x8E, 0xB7, 0x0E, 
0x6B, 0x0E, 0x06, 0xFB, 0x33, 0x35, 0x48, 0x71, 0xB8, 0x9D, 0x27, 0x8B, 0xC4, 0x65, 0x5F, 0x0D, 
0x86, 0x76, 0x9C, 0x44, 0x7A, 0xF6, 0x95, 0x5C, 0xF6, 0x5D, 0x32, 0x08, 0x33, 0xA4, 0x54, 0xB6, 
0x18, 0x3F, 0x68, 0x5C, 0xF2, 0x42, 0x4A, 0x85, 0x38, 0x54, 0x83, 0x5F, 0xD1, 0xE8, 0x2C, 0xF2, 
0xAC, 0x11, 0xD6, 0xA8, 0xED, 0x63, 0x6A};


const unsigned char AWS_IOT_CERTIFICATE[] = {0x30, 0x82, 0x03, 0x5A, 0x30, 0x82, 0x02, 0x42, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x15, 0x00, 
0x92, 0x5C, 0xBB, 0xBC, 0xBE, 0x6C, 0x84, 0xFB, 0xF9, 0x67, 0x33, 0x3F, 0xEF, 0xF1, 0x55, 0x5C, 
0x3A, 0x34, 0x79, 0xFD, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 
0x0B, 0x05, 0x00, 0x30, 0x4D, 0x31, 0x4B, 0x30, 0x49, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x0C, 0x42, 
0x41, 0x6D, 0x61, 0x7A, 0x6F, 0x6E, 0x20, 0x57, 0x65, 0x62, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 
0x63, 0x65, 0x73, 0x20, 0x4F, 0x3D, 0x41, 0x6D, 0x61, 0x7A, 0x6F, 0x6E, 0x2E, 0x63, 0x6F, 0x6D, 
0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x4C, 0x3D, 0x53, 0x65, 0x61, 0x74, 0x74, 0x6C, 0x65, 0x20, 
0x53, 0x54, 0x3D, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6E, 0x67, 0x74, 0x6F, 0x6E, 0x20, 0x43, 0x3D, 
0x55, 0x53, 0x30, 0x1E, 0x17, 0x0D, 0x31, 0x37, 0x30, 0x38, 0x32, 0x35, 0x31, 0x33, 0x35, 0x37, 
0x32, 0x36, 0x5A, 0x17, 0x0D, 0x34, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 
0x39, 0x5A, 0x30, 0x1E, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x13, 0x41, 
0x57, 0x53, 0x20, 0x49, 0x6F, 0x54, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 
0x74, 0x65, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 
0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0F, 0x00, 0x30, 0x82, 0x01, 0x0A, 0x02, 0x82, 
0x01, 0x01, 0x00, 0xB9, 0xCF, 0x6E, 0x84, 0x86, 0x52, 0x89, 0x19, 0x9B, 0x4A, 0x03, 0x9A, 0x82, 
0x61, 0x91, 0x4E, 0xF7, 0xBA, 0x0F, 0xAC, 0x53, 0x86, 0x34, 0x49, 0xEE, 0xE3, 0x9F, 0x44, 0x2A, 
0xB6, 0x58, 0xF5, 0x9D, 0x46, 0x14, 0xD7, 0xC7, 0x1A, 0x2C, 0x7C, 0x56, 0x3D, 0xBF, 0x1D, 0xA9, 
0x4F, 0x1A, 0xE0, 0x12, 0x21, 0x6A, 0x13, 0x8B, 0x74, 0x3D, 0x23, 0xD3, 0x47, 0x97, 0x37, 0x45, 
0xF1, 0x71, 0xD5, 0x7B, 0x5D, 0x20, 0xEE, 0xBF, 0x04, 0x62, 0x45, 0x8C, 0x3A, 0xD2, 0x65, 0x98, 
0x4C, 0x5C, 0xF5, 0x39, 0x90, 0x04, 0x23, 0x1C, 0x9B, 0x9C, 0x0F, 0xBB, 0x5B, 0xF9, 0xDD, 0xDC, 
0xD2, 0xAB, 0xC3, 0x4B, 0xC6, 0x48, 0xCF, 0xE1, 0x1C, 0x2E, 0xF0, 0x5A, 0xC6, 0x71, 0x52, 0xF9, 
0xCF, 0x90, 0x6F, 0xD1, 0xA9, 0x89, 0x1F, 0xCF, 0x6C, 0x43, 0xCD, 0x49, 0x98, 0x5D, 0x38, 0xE3, 
0xF9, 0x91, 0x43, 0xD6, 0xAC, 0x0B, 0xC0, 0xFE, 0x12, 0x9E, 0xEB, 0x0B, 0x3A, 0x06, 0x3F, 0x2D, 
0x42, 0x07, 0x5B, 0xF7, 0x50, 0x1F, 0xFE, 0x1D, 0xC8, 0x2E, 0x9E, 0x64, 0xCA, 0x1C, 0xFF, 0x28, 
0x63, 0xB4, 0x75, 0x2A, 0x00, 0xDB, 0x57, 0xF0, 0xD4, 0x6B, 0xB1, 0x83, 0x44, 0x8D, 0x4A, 0xD6, 
0x24, 0x48, 0x16, 0x5C, 0xE4, 0xEC, 0xA1, 0xA4, 0xD8, 0x6D, 0xB3, 0x5D, 0x60, 0x11, 0x3F, 0xC1, 
0xBA, 0x83, 0x65, 0x4C, 0xD6, 0x72, 0x89, 0xBD, 0x37, 0x58, 0x4A, 0x16, 0x21, 0xD8, 0x2A, 0x2D, 
0xD9, 0xA8, 0x32, 0xEB, 0xA5, 0xFD, 0xCB, 0xD5, 0xB8, 0xD6, 0x19, 0xFA, 0xCB, 0xEE, 0xA5, 0xAA, 
0xD7, 0x05, 0x39, 0x76, 0x66, 0x57, 0x87, 0x81, 0xC4, 0x5E, 0x51, 0x0B, 0x28, 0x96, 0x89, 0x1B, 
0x3E, 0x04, 0x76, 0x34, 0x76, 0xD8, 0x97, 0xE7, 0xB3, 0x16, 0xB6, 0x19, 0xA8, 0x1A, 0x00, 0x3E, 
0xAC, 0x72, 0x35, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x60, 0x30, 0x5E, 0x30, 0x1F, 0x06, 0x03, 
0x55, 0x1D, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xD4, 0xD1, 0x24, 0x61, 0xE7, 0xEB, 0x92, 
0xD2, 0xA6, 0xB8, 0xE7, 0x27, 0x8D, 0x33, 0xF8, 0xE7, 0xD4, 0xA5, 0x23, 0x15, 0x30, 0x1D, 0x06, 
0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0xDA, 0xA6, 0x3B, 0x5A, 0x2A, 0xBC, 0x7E, 0x5F, 
0x9D, 0x71, 0x54, 0x28, 0x01, 0xE7, 0x5F, 0x81, 0x7F, 0xB6, 0x61, 0xDA, 0x30, 0x0C, 0x06, 0x03, 
0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 
0x0F, 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 
0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0B, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x16, 0x70, 
0xE1, 0xF5, 0xB6, 0x19, 0x28, 0x5A, 0xF9, 0xBF, 0xE3, 0xD6, 0x99, 0x1D, 0x25, 0x33, 0xD7, 0xD8, 
0xC9, 0x34, 0xD6, 0x76, 0xC1, 0xFE, 0x7B, 0x36, 0xC7, 0x60, 0x0B, 0x8F, 0xD0, 0x03, 0xFA, 0x78, 
0x2A, 0xDF, 0x0B, 0x11, 0x9B, 0x97, 0xB9, 0x0D, 0x4A, 0xC7, 0x63, 0xA3, 0x62, 0x0E, 0x39, 0xC6, 
0xD5, 0x53, 0x89, 0xBB, 0x8A, 0x32, 0x14, 0x65, 0x5D, 0xFE, 0x29, 0x08, 0x0D, 0x8E, 0x62, 0xC3, 
0x11, 0x32, 0xF2, 0x72, 0x7D, 0xFB, 0x40, 0xD1, 0xAF, 0xCC, 0x4A, 0x8B, 0xFA, 0xA1, 0x00, 0xDE, 
0x3D, 0x59, 0x45, 0xC5, 0x46, 0xCC, 0x3E, 0x10, 0xC7, 0xFC, 0x73, 0x9D, 0xDA, 0xC2, 0x61, 0x3B, 
0x18, 0x8F, 0x53, 0xF8, 0x8E, 0x55, 0xB4, 0x76, 0x5F, 0x18, 0x7B, 0x54, 0x6E, 0x88, 0xA8, 0x57, 
0x24, 0x40, 0xF1, 0xB5, 0x40, 0x2A, 0x1D, 0xF6, 0xB3, 0x82, 0x67, 0xD9, 0xE8, 0x2A, 0x41, 0x78, 
0x2D, 0x83, 0xD3, 0x1E, 0xAC, 0x02, 0xE3, 0xEA, 0xD2, 0xC5, 0x4F, 0xCE, 0x60, 0x15, 0xBA, 0x5B, 
0xD6, 0xB9, 0x14, 0xA8, 0x98, 0x49, 0x0D, 0xDE, 0x4A, 0x4E, 0x85, 0x8D, 0x15, 0xA1, 0x37, 0x66, 
0x32, 0x5B, 0x5B, 0x5E, 0xE6, 0x5C, 0xB3, 0x0E, 0x44, 0x3C, 0x64, 0x6D, 0xC7, 0xDF, 0x0E, 0x0F, 
0xD6, 0x69, 0xFB, 0x1E, 0x00, 0xBF, 0x59, 0xF7, 0x0E, 0xD4, 0x21, 0xC1, 0x11, 0x40, 0x4A, 0x57, 
0x7D, 0x16, 0xE2, 0x28, 0x79, 0x79, 0x62, 0x1C, 0xD6, 0xAA, 0xB6, 0x96, 0x88, 0x4B, 0x81, 0xDB, 
0xD3, 0x40, 0x87, 0x19, 0x10, 0x48, 0x3A, 0x51, 0x7A, 0xBA, 0xBE, 0xE5, 0x38, 0x04, 0x8E, 0x92, 
0xEF, 0x06, 0xA0, 0xFE, 0x97, 0x76, 0x81, 0xB1, 0x05, 0x18, 0x7D, 0xE1, 0x46, 0xBE, 0x96, 0x47, 
0xB7, 0x02, 0xF9, 0x76, 0xB7, 0xAF, 0x70, 0x53, 0xBC, 0xCA, 0x4E, 0x3D, 0xEE, 0x0B};

const unsigned char AWS_IOT_PRIVATE_KEY[] = {0x30, 0x82, 0x04, 0xA3, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01, 0x01, 0x00, 0xB9, 0xCF, 0x6E, 0x84, 
0x86, 0x52, 0x89, 0x19, 0x9B, 0x4A, 0x03, 0x9A, 0x82, 0x61, 0x91, 0x4E, 0xF7, 0xBA, 0x0F, 0xAC, 
0x53, 0x86, 0x34, 0x49, 0xEE, 0xE3, 0x9F, 0x44, 0x2A, 0xB6, 0x58, 0xF5, 0x9D, 0x46, 0x14, 0xD7, 
0xC7, 0x1A, 0x2C, 0x7C, 0x56, 0x3D, 0xBF, 0x1D, 0xA9, 0x4F, 0x1A, 0xE0, 0x12, 0x21, 0x6A, 0x13, 
0x8B, 0x74, 0x3D, 0x23, 0xD3, 0x47, 0x97, 0x37, 0x45, 0xF1, 0x71, 0xD5, 0x7B, 0x5D, 0x20, 0xEE, 
0xBF, 0x04, 0x62, 0x45, 0x8C, 0x3A, 0xD2, 0x65, 0x98, 0x4C, 0x5C, 0xF5, 0x39, 0x90, 0x04, 0x23, 
0x1C, 0x9B, 0x9C, 0x0F, 0xBB, 0x5B, 0xF9, 0xDD, 0xDC, 0xD2, 0xAB, 0xC3, 0x4B, 0xC6, 0x48, 0xCF, 
0xE1, 0x1C, 0x2E, 0xF0, 0x5A, 0xC6, 0x71, 0x52, 0xF9, 0xCF, 0x90, 0x6F, 0xD1, 0xA9, 0x89, 0x1F, 
0xCF, 0x6C, 0x43, 0xCD, 0x49, 0x98, 0x5D, 0x38, 0xE3, 0xF9, 0x91, 0x43, 0xD6, 0xAC, 0x0B, 0xC0, 
0xFE, 0x12, 0x9E, 0xEB, 0x0B, 0x3A, 0x06, 0x3F, 0x2D, 0x42, 0x07, 0x5B, 0xF7, 0x50, 0x1F, 0xFE, 
0x1D, 0xC8, 0x2E, 0x9E, 0x64, 0xCA, 0x1C, 0xFF, 0x28, 0x63, 0xB4, 0x75, 0x2A, 0x00, 0xDB, 0x57, 
0xF0, 0xD4, 0x6B, 0xB1, 0x83, 0x44, 0x8D, 0x4A, 0xD6, 0x24, 0x48, 0x16, 0x5C, 0xE4, 0xEC, 0xA1, 
0xA4, 0xD8, 0x6D, 0xB3, 0x5D, 0x60, 0x11, 0x3F, 0xC1, 0xBA, 0x83, 0x65, 0x4C, 0xD6, 0x72, 0x89, 
0xBD, 0x37, 0x58, 0x4A, 0x16, 0x21, 0xD8, 0x2A, 0x2D, 0xD9, 0xA8, 0x32, 0xEB, 0xA5, 0xFD, 0xCB, 
0xD5, 0xB8, 0xD6, 0x19, 0xFA, 0xCB, 0xEE, 0xA5, 0xAA, 0xD7, 0x05, 0x39, 0x76, 0x66, 0x57, 0x87, 
0x81, 0xC4, 0x5E, 0x51, 0x0B, 0x28, 0x96, 0x89, 0x1B, 0x3E, 0x04, 0x76, 0x34, 0x76, 0xD8, 0x97, 
0xE7, 0xB3, 0x16, 0xB6, 0x19, 0xA8, 0x1A, 0x00, 0x3E, 0xAC, 0x72, 0x35, 0x02, 0x03, 0x01, 0x00, 
0x01, 0x02, 0x82, 0x01, 0x00, 0x0C, 0x8E, 0x9D, 0x2C, 0x6D, 0x9B, 0x74, 0x52, 0x7B, 0xB1, 0x23, 
0xCF, 0x34, 0x52, 0x7D, 0xAC, 0x75, 0x87, 0x68, 0x79, 0xBF, 0xE7, 0x48, 0xEF, 0x5A, 0x2A, 0x9D, 
0xDF, 0xD0, 0x77, 0x24, 0x49, 0xED, 0x08, 0x08, 0x6E, 0x90, 0xB1, 0x0F, 0x22, 0x93, 0xFD, 0x76, 
0x45, 0xFD, 0xE4, 0x2F, 0xAF, 0xC6, 0xE9, 0xE5, 0x2E, 0x4E, 0xF5, 0x5B, 0x10, 0x69, 0xBD, 0xE3, 
0xD5, 0x43, 0x6F, 0xCE, 0xBE, 0x9B, 0xA8, 0xAE, 0x8A, 0x13, 0xF4, 0xAA, 0xE3, 0x82, 0x57, 0x93, 
0x52, 0x74, 0x59, 0x6C, 0xCA, 0xD1, 0xCA, 0x0E, 0xCD, 0x84, 0xA8, 0x6B, 0x82, 0x90, 0xA9, 0xE5, 
0x97, 0xFD, 0xCD, 0x6A, 0xF8, 0x36, 0xCD, 0xBE, 0xAB, 0xF5, 0xCD, 0x9E, 0xCA, 0x75, 0x88, 0x05, 
0xAE, 0x92, 0xDD, 0x59, 0x28, 0x85, 0x65, 0xCC, 0xB3, 0x8E, 0xA4, 0x05, 0x6D, 0x01, 0x35, 0x3F, 
0xCF, 0x91, 0x70, 0x93, 0x45, 0x81, 0xE7, 0x19, 0x24, 0xB2, 0xF2, 0x42, 0x31, 0x57, 0x7B, 0x86, 
0xD0, 0xD5, 0x20, 0xDE, 0x22, 0x24, 0xD2, 0xE4, 0xD4, 0x60, 0x63, 0xED, 0x5C, 0x8A, 0x24, 0x27, 
0x7C, 0xC2, 0x05, 0x62, 0xD3, 0x36, 0xFC, 0xDC, 0x83, 0xF3, 0xE0, 0x8C, 0x57, 0xFD, 0x2B, 0x31, 
0xF5, 0xDA, 0xEE, 0xBF, 0xFB, 0xFC, 0xA5, 0xD4, 0x4A, 0x92, 0xF6, 0xB3, 0xF6, 0x93, 0xD9, 0x71, 
0xF2, 0x0E, 0xEF, 0x98, 0xD0, 0x02, 0x5C, 0x92, 0x88, 0x6C, 0xE5, 0x3A, 0x0F, 0xC1, 0xB9, 0x7A, 
0xBC, 0xD7, 0xBC, 0xC6, 0xF8, 0x0A, 0x63, 0xDA, 0x3A, 0x09, 0x3B, 0x7C, 0x80, 0x0E, 0xA7, 0x41, 
0xBA, 0x7E, 0xF2, 0xBC, 0xD6, 0xE6, 0xC1, 0x54, 0x54, 0x22, 0x95, 0x5A, 0xC6, 0x96, 0x6D, 0x46, 
0x74, 0xE2, 0x3F, 0xAB, 0x91, 0x64, 0x11, 0xE8, 0x75, 0x6E, 0x2B, 0xDB, 0x9D, 0x5D, 0x6C, 0xB5, 
0xC6, 0xCE, 0x16, 0x36, 0x21, 0x02, 0x81, 0x81, 0x00, 0xDE, 0xEB, 0x08, 0xE8, 0x35, 0xA3, 0x8F, 
0x2E, 0x01, 0x72, 0xE2, 0xDF, 0x01, 0xED, 0x1B, 0xBA, 0x22, 0xD8, 0x29, 0x73, 0xDB, 0x73, 0x03, 
0xD7, 0x48, 0xD8, 0xEE, 0x23, 0x13, 0xB3, 0x92, 0x41, 0x3D, 0x2E, 0x07, 0xEF, 0xE5, 0xD6, 0xAD, 
0x64, 0x67, 0x76, 0xF7, 0x01, 0x71, 0x63, 0x6C, 0x23, 0xAA, 0x3F, 0xCC, 0x08, 0xD3, 0x1F, 0x52, 
0x1F, 0xED, 0xAB, 0x52, 0xC9, 0x68, 0x63, 0xEC, 0x0C, 0x64, 0x1D, 0x99, 0xE5, 0xD0, 0x35, 0xFF, 
0x83, 0x8A, 0x81, 0xA3, 0xF0, 0x0C, 0x02, 0xC5, 0x30, 0xA7, 0x83, 0x1F, 0xC9, 0xE8, 0xBD, 0x98, 
0x62, 0x18, 0x31, 0x66, 0xE2, 0x72, 0xA2, 0xA3, 0xCD, 0x64, 0x93, 0xF1, 0x2E, 0xF9, 0xB4, 0x6B, 
0x9A, 0xA7, 0x5F, 0xA2, 0x5B, 0x8F, 0xAC, 0x0F, 0xBF, 0x7B, 0x88, 0x2F, 0x9A, 0x68, 0x89, 0x4D, 
0x56, 0x36, 0x72, 0xCC, 0x7D, 0x89, 0x21, 0xEC, 0xD9, 0x02, 0x81, 0x81, 0x00, 0xD5, 0x62, 0x9E, 
0xA1, 0xC0, 0x58, 0x1B, 0x43, 0x8F, 0x3F, 0x67, 0x8F, 0x56, 0x86, 0xBA, 0xCA, 0x2D, 0x6C, 0x04, 
0xAF, 0x87, 0x27, 0xEC, 0x62, 0x37, 0xB4, 0x48, 0x4C, 0x11, 0xCA, 0x27, 0x23, 0x94, 0x09, 0x79, 
0xF1, 0x02, 0x1E, 0x63, 0x59, 0x72, 0xC8, 0x60, 0xA5, 0x03, 0x9C, 0xE9, 0x6E, 0x4C, 0x1D, 0xEF, 
0x44, 0xFE, 0x45, 0x82, 0x9E, 0x5F, 0x1D, 0xAA, 0x16, 0x59, 0x3E, 0x19, 0x22, 0x0B, 0xC6, 0x07, 
0xEB, 0xEB, 0xC0, 0xF5, 0x88, 0x4E, 0x66, 0xAA, 0x5A, 0x79, 0x24, 0x02, 0x94, 0x22, 0x80, 0x95, 
0xA5, 0xB4, 0xF1, 0x32, 0xFE, 0x64, 0xB1, 0xF9, 0xB3, 0xCE, 0x2F, 0x30, 0xD5, 0x1E, 0x01, 0x27, 
0xE4, 0xE0, 0x86, 0xF0, 0x76, 0x29, 0x4C, 0x66, 0x53, 0x4E, 0x62, 0x83, 0x12, 0xE0, 0xBD, 0x62, 
0x1B, 0x57, 0xE6, 0x58, 0x6B, 0x36, 0xD7, 0x7A, 0xF8, 0x57, 0x7F, 0x86, 0xBD, 0x02, 0x81, 0x81, 
0x00, 0xB8, 0x2E, 0xD0, 0x44, 0x34, 0x95, 0x78, 0x66, 0xD5, 0xB1, 0x9B, 0xFC, 0x10, 0x76, 0x5D, 
0x93, 0x74, 0xD8, 0xCF, 0x9F, 0x37, 0x71, 0x97, 0x79, 0xD8, 0x69, 0xCC, 0x90, 0xD4, 0xE5, 0x68, 
0xF1, 0x58, 0x60, 0x61, 0x14, 0x78, 0xFD, 0xE0, 0x73, 0xF5, 0xFC, 0xD8, 0x67, 0xAB, 0xCD, 0x2E, 
0xFB, 0x64, 0xDE, 0xA3, 0x71, 0xA3, 0x26, 0xDC, 0xCF, 0x1E, 0xAB, 0x90, 0x92, 0x73, 0x1B, 0x24, 
0x5C, 0xB4, 0x97, 0xB4, 0xA1, 0xAA, 0x60, 0x03, 0x47, 0x27, 0x38, 0xA8, 0x40, 0x5D, 0x5C, 0x28, 
0x9B, 0x63, 0xBC, 0xB6, 0x96, 0x38, 0x23, 0xF6, 0xF5, 0x0D, 0xF2, 0x3B, 0x84, 0xDC, 0x9C, 0xBE, 
0xE4, 0xA4, 0xB6, 0x8B, 0xEF, 0x79, 0x47, 0xF6, 0x24, 0x69, 0x28, 0x5E, 0x58, 0x72, 0xA4, 0x02, 
0xBA, 0xFE, 0x91, 0x6E, 0x6B, 0x90, 0xF5, 0xE9, 0x1D, 0x53, 0x8D, 0x94, 0xA2, 0x20, 0x9D, 0x14, 
0x39, 0x02, 0x81, 0x80, 0x27, 0x7B, 0x4D, 0xDA, 0xA3, 0xDA, 0x29, 0x81, 0x40, 0x99, 0xFC, 0xB1, 
0x5A, 0xD3, 0x26, 0xF0, 0x8D, 0xA2, 0xF4, 0xE2, 0xFD, 0x60, 0xF7, 0xAD, 0xDC, 0x9C, 0xB0, 0xDB, 
0xD2, 0x56, 0xD3, 0x13, 0x14, 0x2B, 0x04, 0xB3, 0x01, 0x2F, 0x5A, 0x36, 0x8C, 0xB4, 0x62, 0x9D, 
0x65, 0xA3, 0xBC, 0xD5, 0x39, 0xA4, 0x38, 0x47, 0x4D, 0xBC, 0xD2, 0xC4, 0x36, 0xD9, 0x28, 0x45, 
0x66, 0x51, 0xC5, 0x18, 0xB5, 0x90, 0xF8, 0x9A, 0x40, 0x4E, 0xBD, 0x9F, 0x70, 0xD2, 0x32, 0x26, 
0xF7, 0x4F, 0x20, 0x63, 0x04, 0x57, 0x42, 0x59, 0x1C, 0xB7, 0x9C, 0x35, 0xD1, 0xAF, 0xD4, 0x81, 
0xDE, 0x5E, 0x80, 0xEC, 0x8D, 0xD6, 0xAC, 0xE8, 0xFE, 0x5A, 0x39, 0x57, 0xC3, 0xA0, 0x6D, 0x36, 
0x70, 0xC4, 0x6D, 0x78, 0x2A, 0xB9, 0x1F, 0xD3, 0xEB, 0x59, 0xA5, 0x76, 0x80, 0xF9, 0x31, 0xB9, 
0x8D, 0x86, 0xFD, 0x09, 0x02, 0x81, 0x80, 0x44, 0x96, 0xAF, 0x3B, 0x68, 0x2E, 0x1C, 0xF3, 0xC8, 
0x44, 0x22, 0x69, 0x3A, 0x51, 0x4A, 0xE9, 0x53, 0x12, 0x6E, 0x7F, 0x40, 0xD3, 0x21, 0x5E, 0x42, 
0xC4, 0x4D, 0x94, 0x7C, 0x81, 0x18, 0x4A, 0xF3, 0x0D, 0xBF, 0x7C, 0x84, 0xD4, 0x9E, 0x50, 0xE3, 
0x39, 0x69, 0xD4, 0xB0, 0x2B, 0x69, 0x24, 0x86, 0xDE, 0xB0, 0xD7, 0x45, 0x8D, 0xCD, 0xB4, 0xFB, 
0x3D, 0x0F, 0x49, 0xF8, 0x07, 0x6A, 0x6A, 0x88, 0x40, 0x66, 0xE0, 0x63, 0x8A, 0xC5, 0xBC, 0x04, 
0xD7, 0x03, 0x46, 0xC9, 0xB3, 0x46, 0xE1, 0x18, 0xEC, 0xE9, 0xB6, 0x2B, 0x23, 0x2D, 0xAD, 0xAE, 
0x7D, 0xD7, 0x4E, 0xC2, 0xC2, 0x1D, 0xC6, 0x45, 0x62, 0xBA, 0xC8, 0xA5, 0xD9, 0xA5, 0xC4, 0x0F, 
0x59, 0x4B, 0xC6, 0x20, 0xC1, 0x1A, 0x75, 0xAF, 0x86, 0x8F, 0x85, 0xE1, 0x53, 0x6F, 0xFB, 0x3E, 
0x22, 0xB9, 0x93, 0xDC, 0x9C, 0x3D, 0x7A};
#endif

#ifdef CARDFORMAT
unsigned char AWS_IOT_ROOT_CA[2000];
unsigned char AWS_IOT_CERTIFICATE[2000];
unsigned char AWS_IOT_PRIVATE_KEY[2000];

int AWS_IOT_ROOT_CA_LENGTH = 1239;
int AWS_IOT_CERTIFICATE_LENGTH = 862;
int AWS_IOT_PRIVATE_KEY_LENGTH = 1191;
#endif


