/**
 * @file timer.c
 * @brief mbed-os implementation of the timer interface needed for AWS.
 */

#include <stddef.h>
#include "timer_interface.h"

TimerExt::TimerExt() {
    unsigned int timeout_ms = 0;
};

char expired(Timer* timer) {
	if (timer->read_ms() > timer->timeout_ms)
	    return 1;
	
	return 0;
}

void countdown_ms(Timer* timer, unsigned int timeout) {
	timer->timeout_ms = timeout;
	timer->reset();
	timer->start();
}

void countdown(Timer* timer, unsigned int timeout) {
	timer->timeout_ms = (timeout * 1000);
	timer->reset();
	timer->start();
}

uint32_t left_ms(Timer* timer) {
	if (timer->read_ms() < timer->timeout_ms)
	    return (timer->timeout_ms - timer->read_ms());
	
	return 0;
}

void InitTimer(Timer* timer) {
	timer->stop();
	timer->reset();
	timer->timeout_ms = 0;
}


