// ECE 4180
// Lab/Project 1
// Jeremy M. Deremer
// Due 26 January, 2017

#include "mbed.h"
#include "PinDetect.h"
#include "LEDColor.h"
#include "RGBLed.h"
#include "MCP23S17.h"
#include "Nav_Switch.h"

PwmOut led(p24);

//   Instantiate pushbuttons on analog pins
PinDetect pb1(p17);
PinDetect pb2(p18);
PinDetect pb3(p19);

//   Instantiate RGBLed and allocate default colors
//RGBLed myRGBled(p23,p22,p21); //RGB PWM pins
//const LEDColor off(0.0,0.0,0.0);
//const LEDColor blue(0.0,0.0,1.0);

//   Instantiate I/O Expander
// Create SPI bus
SPI spi(p5, p6, p7);
char Opcode = 0x40;
// Next create a MCP23S17
MCP23S17 chip = MCP23S17(spi, p20, Opcode);
DigitalOut led1(LED1); // mbed LED1 is used for test status display

//    Instantiate Nav Joystick
Nav_Switch myNav(p15, p12, p13, p11, p8); //pin order on Sparkfun breakout

float inc = 0.1f;
float val = 0.5f;

// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
{
    val = led.read();
    if (val == 0.00f)
    {
        led.write(0.50f);  // 50% duty cycle
    }
    else
    {
        led.write(0.00f);  // 0% duty cycle
    }
}

// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
{
    // add brightness
    val = led.read();
    if (val < 1.00f)
    {
        val += inc; 
        led.write(val);
    }
}

// Callback routine is interrupt activated by a debounced pb3 hit
void pb3_hit_callback (void)
{
    // subtract brightness
    val = led.read();
    if (val > 0.0f)
    {
        val -= inc; 
        led.write(val);
    }
}

int main() {
    
    led.write(0.5f);  // 50% duty cycle
    
    // Use internal pullups for the three pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    // pushbuttons now setup and running
    
    //  Set all 8 Port A bits to output direction
    chip.direction(PORT_A, 0x00);
    //  Set all 8 Port B bits to input direction
    chip.direction(PORT_B, 0xFF);
    
    while(1)          // led flashing
    {
        // write 0xAA to MCP23S17 Port A
        chip.write(PORT_A, 0xAA);
        
        // read back value from MCP23S17 Port B and display B0 on mbed led1
        if ((chip.read(PORT_B)& 0x01) == 0x01)
        {
            chip.write(PORT_A, 0x55);
        }
        
        //chip.write(PORT_A, (chip.read(PORT_B)& 0x01));
        
        
        //with pullups a button hit is a "0" - "~" inverts data to leds
        mbedleds = ~(myNav & 0x0F); //update leds with nav switch direction inputs
        if(myNav.fire()) mbedleds = 0x0F; //special all leds on case for fire (center button)
        //or use - if(myNav[4]==0) mbedleds = 0x0F; //can index a switch bit like this
        //wait(0.02);
        
    }
}