#include "mbed.h"
 
//Class to control an RGB LED using three PWM pins
class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
    void write(LEDColor c);
    RGBLed operator = (LEDColor c) {
        write(c);
        return *this;
    };
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};
 
RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}
 
void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}
void RGBLed::write(LEDColor c)
{
    _redpin = c.red;
    _greenpin = c.green;
    _bluepin = c.blue;
}
 
////classes could be moved to include file
// 
// 
////Setup RGB led using PWM pins and class
//RGBLed myRGBled(p23,p22,p21); //RGB PWM pins
// 
////setup some color objects in flash using const's
//const LEDColor red(1.0,0.0,0.0);
//const LEDColor green(0.0,0.2,0.0);
////brighter green LED is scaled down to same as red and
////blue LED outputs on Sparkfun RGBLED
//const LEDColor blue(0.0,0.0,1.0);
//const LEDColor yellow(1.0,0.2,0.0);
//const LEDColor white(1.0,0.2,1.0);
// 
//int main()
//{
//    while(1) {
//        myRGBled = red;
//        //myRGBled.write(1.0,0.0,0,0); //red
//        wait(2.0);
//        myRGBled = green;
//        //myRGBled.write(0.0,1.0,0.0); //green
//        wait(2.0);
//        myRGBled = blue;
//        //myRGBled.write(0.0,0.0,1.0); //blue
//        wait(2.0);
//        myRGBled = red + green; //yellow = red + green
//        wait(2.0);
//        //white with a slow fade to black dimming effect
//        for (float brightness=1.0; brightness>=0.0001; brightness*=0.99) {
//            myRGBled = white * brightness;
//            wait(0.005);
//        }
//        wait(2.0);
//    }
//}