#include "mbed.h"
#include "rtos.h"
#include "RGBLed.h"
#include "uLCD_4DGL.h"
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// RGBLed myRGBled(p21,p22,p23); //RGB PWM pins

Serial bluemod(p28,p27);
PwmOut red(p21);
PwmOut green(p22);
PwmOut blue(p23);

uLCD_4DGL uLCD(p9, p10, p11);

Thread t1;
Thread t2;
Thread t3;
Thread t4;

Mutex lk_LCD;
 
void rgb_t3() {

    while (true) {
        
    }
}

void lcd_t1() {
    while (true) {
        for (int i = 0; i < 10; i++)
        {
            lk_LCD.lock();
            uLCD.locate(2,2);
            uLCD.printf("\n Hello World! \nCount by one is %d!\n", i);
            lk_LCD.unlock();
            Thread::wait(1000);
        }
    }
}

void lcd_t2() {
    while (true) {
        for (int j = 0; j < 20; j += 2)
        {
            lk_LCD.lock();
            uLCD.locate(4,4);
            uLCD.printf("\n Hello World! \nCount by two is %d!\n", j);
            lk_LCD.unlock();
            Thread::wait(2000);
        }
    }
}
 
 

int main() {
    // myRGBled.write(0.0, 0.0, 0.0);  
    char bred=0;
    char bgreen=0;
    char bblue=0; 
    red = green = blue = 0;
    
    t3.start(rgb_t3);
    t1.start(lcd_t1);
    t2.start(lcd_t2);
    
    while (true) {
        if (bluemod.getc()=='!') {
            if (bluemod.getc()=='C') { //color data packet
                bred = bluemod.getc(); // RGB color values
                bgreen = bluemod.getc();
                bblue = bluemod.getc();
                if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) { //checksum OK?
                    red = bred/255.0; //send new color to RGB LED PWM outputs
                    green = bgreen/255.0;
                    blue = bblue/255.0;
                }
            }
        }
        led1 = !led1;
        Thread::wait(500);
    }
}