#include "mbed.h"
#include "rtos.h"
#include "Motor.h"

Serial pc(USBTX, USBRX);
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn Switch(p15);

//SERVO for arm
PwmOut arm(p26);

//LEDS
PwmOut red(p25);
PwmOut green(p24);
PwmOut blue(p23);

DigitalOut MouthUp(p11);
DigitalOut MouthDown(p12);
DigitalOut MouthCenter(p10);

//SD card/audio
PwmOut Speaker(p22);
/* //For SD custom songs
AnalogOut DACout(p18);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
wave_player waver(&DACout,&Speaker);
char buffer[20];
FILE *wave_file;
*/
//motor for wheels

Motor wheel(p21, p6, p5); // pwm, fwd, rev

Thread t2; // LED Color
Thread t3; // Speaker Music / Audio
Thread t4; // Motor Control

Mutex state;
int angerlevel;
int priority=1;
bool pushFlag = false;
 

void LEDThread() {
    //TODO: Add colors according to angerlevel
    while(1){
        if (pushFlag&&priority==1)
        {
            state.lock();   //lock to read the angerlevel
            switch(angerlevel){
                case 1:
                    //turn on leds
                    MouthCenter=1;
                    MouthUp=1;
                    red=1.0;
                    green=1.0;
                    blue=1.0;
                    break;
                case 2:
                    //LEDS/AUDIO
                    red=1.0;
                    green=0.0;
                    blue=1.0;
                    MouthUp=0;
                    break;
                case 3:
                    MouthDown=1;
                    red=1.0;
                    green=0.0;
                    blue=0.0;
                    break;
                default:
                    //case 0 do nothing
                    break;
            }
            priority=2;
            state.unlock();
        }
    }
}

void AudioThread() {
    //PWM/AMP? to play audio?
    //TODO: get sound on SD card and confirm this will work
    //mabye multiple sounds according to what angerlevel
    while(1){
        if (pushFlag&&priority==2)
        {
            state.lock();   //lock to read the angerlevel
            switch(angerlevel){
                case 2:
                    //AUDIO
                    /*for SD custom sound
                    for (int a=1;a<40; a++){
                        sprintf(buffer,"/sd//voice%d.wav",a);    
                        wave_file=fopen(buffer,"r");
                        waver.play(wave_file);
                        fclose(wave_file);
                    }*/
                    //siren affect
                    arm.period(1.0/800.0);
                    Speaker = float(48)/50.0;
                    wait(2.5);
                    Speaker=0;
                    break;
                case 3:
                    break;
                default:
                    //Nothing to do here
                    break;
            }
            priority=3;
            state.unlock();
        }
    }
}

void WheelsThread() {
    //Drive around randomly
    //TODO: add random driving for both motors(current:example for 1 motor)
    while(1){
        if (pushFlag&&priority==3)
        {

            state.lock();   //lock to read the angerlevel
            switch(angerlevel){
                case 3:
                        arm.period(0.001);
                        wheel.speed(1.0);
                        wait(2.5);

                        arm.period(1.0/969.0);
                        Speaker = float(46)/50.0;
                        wait(.5);
                        arm.period(1.0/800.0);
                        wait(.5);

                        arm.period(0.001);
                        wheel.speed(-1.0);
                        wait(2.5);
                        
                        arm.period(1.0/969.0);
                        Speaker = float(48)/50.0;
                        wait(.5);
                        arm.period(1.0/800.0);
                        wait(.5);
                        Speaker=0;

                        arm.period(0.001);
                        wheel.speed(0.0);
                        wait(0.04);
                    break;
                default:
                    //nothing
                    break;
            }
            priority=1;
            state.unlock();
        }
    }
}

 
void fallInterrupt(){
    priority=1;
    pushFlag=true;
}

void init(){

    //start threads
    t2.start(LEDThread);
    t3.start(AudioThread);
    t4.start(WheelsThread);

}

int main() {
    init();

    while(1) {
        while(Switch) {
            //* code 
        }
        fallInterrupt();
            //start servo
            state.lock();   //lock for period + angerlevel
            arm.period(0.020);          // servo requires a 20ms period
            arm.pulsewidth(0.002);
            wait(0.5);
            arm.pulsewidth(0.0013);
            wait(0.5);

            angerlevel++;
            state.unlock();
            wait(1);
            pushFlag=false;
    }
    pc.printf("exited");
}