#ifndef SENSORS_MPU9250_H
#define SENSORS_MPU9250_H
#include "mbed.h"

//InvenSense MPU-9250
//Driver for the nrf51822 mcu

#define SHORT_SWAP_BYTE(s) (((s & 0xff) << 8) | ((s & 0xff00) >> 8))


#define MPU9250_ID 0x71
#define MPU9250_REG_ID 0x75 //Should read out MPU9250_ID


#define MPU9250_REG_GYRO_X_H 0x43
#define MPU9250_REG_GYRO_X_L 0x44
#define MPU9250_REG_GYRO_Y_H 0x45
#define MPU9250_REG_GYRO_Y_L 0x46
#define MPU9250_REG_GYRO_Z_H 0x47
#define MPU9250_REG_GYRO_Z_L 0x48
#define MPU9250_REG_ACCEL_X_H 0x3B
#define MPU9250_REG_ACCEL_X_L 0x3C
#define MPU9250_REG_ACCEL_Y_H 0x3D
#define MPU9250_REG_ACCEL_Y_L 0x3E
#define MPU9250_REG_ACCEL_Z_H 0x3F
#define MPU9250_REG_ACCEL_Z_L 0x40
#define MPU9250_REG_TEMP_H 0x41
#define MPU9250_REG_TEMP_L 0x42

#define MPU9250_REG_CFG 0x1A
#define MPU9250_REG_GYROCFG 0x1B
#define MPU9250_REG_ACCELCFG 0x1C
#define MPU9250_REG ACCELCFG2 0x1D
#define MPU9250_REG_MOTDETSTAT 0x61
#define MPU9250_REG_MOTDETCTRL 0x69
#define MPU9250_REG_USRCTRL 0x6A
#define MPU9250_REG_PWR1 0x6B
#define MPU9250_REG_PWR2 0x6C
#define MPU9250_REG_INTCFG 0x37
#define MPU9250_REG_INTEN 0x38
#define MPU9250_REG_WOMT 0x1F

#define MPU9250_REG_DMP_INTSTAT 0x39
#define MPU9250_REG_DMP_BANK 0x6D
#define MPU9250_REG_DMP_RW_PNT 0x6E
#define MPU9250_REG_DMP_REG 0x6F
#define MPU9250_REG_DMP_REG1 0x70
#define MPU9250_REG_DMP_REG2 0x71

#define MPU9250_MAG_ADDRESS 0x0C
#define MPU9250_MAG_REG_STATUS 0x02
#define MPU9250_MAG_REG_X_L 0x03
#define MPU9250_MAG_REG_X_H 0x04
#define MPU9250_MAG_REG_Y_L 0x05
#define MPU9250_MAG_REG_Y_H 0x06
#define MPU9250_MAG_REG_Z_L 0x07
#define MPU9250_MAG_REG_Z_H 0x08
#define MPU9250_MAG_REG_CNTL 0x0A //0b0 power down, 0b1 single measurement, 0b1000 self-test, 0b1111 fuse-rom access
#define MPU9250_MAG_REG_FUSE_XADJ 0x10
#define MPU9250_MAG_REG_FUSE_YADJ 0x11
#define MPU9250_MAG_REG_FUSE_ZADJ 0x12
#define MPU9250_MAG_REG_I2CDIS 0x0F

#define MPU9250_GYROSCALE_250 0x00
#define MPU9250_GYROSCALE_500 0x08
#define MPU9250_GYROSCALE_1000 0x10
#define MPU9250_GYROSCALE_2000 0x18
#define MPU9250_ACCSCALE_2 0x00
#define MPU9250_ACCSCALE_4 0x08
#define MPU9250_ACCSCALE_8 0x10
#define MPU9250_ACCSCALE_16 0x18


struct __attribute__((__packed__)) MPU9250_MAG_DATA {
    uint16_t x;
    uint16_t y;
    uint16_t z;
    uint8_t isValid;    
};

struct __attribute__((__packed__)) MPU9250_ACCEL_DATA {
    uint16_t x;
    uint16_t y;
    uint16_t z;
    uint8_t isValid;    
};

struct __attribute__((__packed__)) MPU9250_GYRO_DATA {
    uint16_t x;
    uint16_t y;
    uint16_t z;
    uint8_t isValid;    
};

struct __attribute__((__packed__)) MPU9250_TEMP_DATA {
    uint16_t temperature;
    uint8_t isValid;    
};

class MPU9250 {
    public: 
        MPU9250(int SCLPin, int SDAPin, int addr);
        MPU9250_GYRO_DATA readGyro();
        MPU9250_MAG_DATA readMag();
        MPU9250_ACCEL_DATA readAccel();
        MPU9250_ACCEL_DATA readAccelNew();
        MPU9250_TEMP_DATA readTemp();
        
        bool init();
        bool wakeup();
        bool standby();
        bool sleep();
        
    private:
        MPU9250();
        I2C i2c;
        int deviceAddress;
        bool readRegister(int addr, uint8_t* data, int length);
        bool writeRegister(int addr, uint8_t data);
        bool readMagRegister(int addr, uint8_t* data, int length);
        bool writeMagRegister(int addr, uint8_t data);
};

#endif