#include <mbed.h>
#include "MPU9250.h"
#include "SEGGER_RTT.h"
#include "SEGGER_RTT.c"
#include "SEGGER_RTT_printf.c"
#include "nrf_drv_clock.h"

#define NRF_CLK_SRC NRF_CLOCK_LFCLKSRC_SYNTH_250_PPM

//MPU-9250 Settings
#define MPU9250_PIN_SCL 14 //P0.14
#define MPU9250_PIN_SDA 13 //P0.13
#define MPU9250_PIN_INT 12 //P0.12
#define MPU9250_I2C_ADDRESS 0b1101001 //AD0 pin for LSB in address is pulled up to logic high

//Define digital outputs
DigitalOut LED = p0;
DigitalOut VIBR = p1;

int acc[4], gyr[3], mag[3], temp, tmp;

MPU9250 mpu9250Sensor(MPU9250_PIN_SCL,MPU9250_PIN_SDA,MPU9250_I2C_ADDRESS);

void updateSensorValue() {        
    MPU9250_ACCEL_DATA accel = mpu9250Sensor.readAccel();
    MPU9250_ACCEL_DATA accelnew = mpu9250Sensor.readAccelNew();
    MPU9250_GYRO_DATA gyro = mpu9250Sensor.readGyro();
    MPU9250_MAG_DATA magn = mpu9250Sensor.readMag();
    MPU9250_TEMP_DATA temp = mpu9250Sensor.readTemp();
    
    float accfactor = 1.0;
    float gyrfactor = 1.0;
    float magfactor = 1.0;       
    
    acc[0] = static_cast<int>(accel.x * accfactor);
    acc[1] = static_cast<int>(accel.y * accfactor);
    acc[2] = static_cast<int>(accel.z * accfactor);
    acc[4] = static_cast<int>(accelnew.x * accfactor);
    gyr[0] = static_cast<int>(gyro.x * gyrfactor);
    gyr[1] = static_cast<int>(gyro.y * gyrfactor);
    gyr[2] = static_cast<int>(gyro.z * gyrfactor);
    mag[0] = static_cast<int>(magn.x * magfactor);
    mag[1] = static_cast<int>(magn.y * magfactor);
    mag[2] = static_cast<int>(magn.z * magfactor);
    tmp = temp.temperature;    
}

//Runs once on boot (called from main method)
void setup() {
    NRF_CLOCK->XTALFREQ = 0xFF; //Reset to default (use external 16MHz crystal)
    NRF_CLOCK->LFCLKSRC = (CLOCK_LFCLKSRC_SRC_RC << CLOCK_LFCLKSRC_SRC_Pos);
    //NRF_CLOCK->LFCLKSRC = 0; // (NRF_CLOCK_LFCLKSRC_SYNTH_250_PPM) synthesize 32KHz clock from main frequency;
    
    NRF_CLOCK->EVENTS_HFCLKSTARTED = 0;
    NRF_CLOCK->TASKS_HFCLKSTART = 1;
    
    while (NRF_CLOCK->EVENTS_HFCLKSTARTED == 0) {}
    
    mpu9250Sensor.init();
}

int main() {
    setup();
    SEGGER_RTT_WriteString(0, "Start output \n");
    
    while (true) {
        updateSensorValue();
        SEGGER_RTT_printf(0, "Acc X:%d, Y:%d, Z:%d\n", acc[0],acc[1],acc[2]);
        SEGGER_RTT_printf(0, "AccNew X:%d\n", acc[4]);
        SEGGER_RTT_printf(0, "Gyr X:%d, Y:%d, Z:%d\n", gyr[0],gyr[1],gyr[2]);
        SEGGER_RTT_printf(0, "Mag X:%d, Y:%d, Z:%d\n", mag[0],mag[1],mag[2]);
        SEGGER_RTT_printf(0, "Temp:%d\n", temp);
        SEGGER_RTT_WriteString(0, "\n");
        wait(0.5);
        /*int tapThresh = 120;
        if (acc[0] > tapThresh){
            LED = 1;
            VIBR = 1;
            wait(0.3);
            LED = !LED;
            VIBR = !VIBR;
            wait(2);
        }*/
    }
}