#include "PI_Cntrl.h"
#include "mbed.h"
#include "Signal.h"
#include "EncoderCounter.h"
#include "DiffCounter.h"
#include "angle_estimator.h"


// define STATES:
#define INIT 0              // at very beginning
#define FLAT 10             // cuboid is flat, motor is controlled to zero
#define BALANCE 20          // balancing
#define SWING_DOWN 30       // move cuboid down




class update_loop
{
public:

    update_loop(float Ts, PinName);
    virtual     ~update_loop();
    InterruptIn button;

private:
    void loop(void);
    Signal signal;
    Thread thread;
    Ticker ticker;
    Mutex mutex;      // mutex to lock critical sections    
    double Ts;
    bool key_was_pressed;
    Timer ti;
    Timer t_but;                            // define button time        // 
    PI_Cntrl vel_cntrl;  // velocity controller for motor
    PI_Cntrl om2zero;  // slow vel. contrl. to bring motor to zero
    Serial pc;
    void sendSignal();
    void pressed(void);             // user Button pressed
    void released(void);            // user Button released
    float cuboid_stab_cntrl(int);
    float vel;
    int CS;
    int kk;
    EncoderCounter counter1;    // 
    DiffCounter diff;              // discrete differentiate, based on encoder data
    float phi1_des;
    angle_estimator AE;
    AnalogOut out;
    LinearCharacteristics i2u;       // output is normalized output
};
