#include "mbed.h"
#include "LinearCharacteristics.h"
#include "IIR_filter.h"
class angle_estimator
{
public:

    angle_estimator(float);
    virtual ~angle_estimator();
    float get_phi1(void);
    float get_gyro(void);
    void calc_angle_phi1(int);

private:
    //------------------------------------------
// ... here define variables like gains etc.
//------------------------------------------
    LinearCharacteristics u2ax;     // use normalized input
    LinearCharacteristics u2ay;      // use normalized input
    LinearCharacteristics u2gz;           // use normalized input
                // 4.6517f = 1/3.752e-3 [V / °/s] * pi/180
 
//-------------DEFINE FILTERS----------------
    IIR_filter f_ax;        // filter ax signals
    IIR_filter f_ay;        // filter ay signals
    IIR_filter f_gz;    // filter gz signals
        
    AnalogIn ax;                      // Analog IN (acc x) on PA_0
    AnalogIn ay;                      // Analog IN (acc y) on PA_1
    AnalogIn gz;                      // Analog IN (gyr z) on PA_4

    float gyro;
    float phi1;
};
