#include "mbed.h"
#include "EncoderCounter.h"
#include "EncoderCounterIndex.h"
#include "DiffCounter.h"
#include "LinearCharacteristics.h"
#include "ThreadFlag.h"
#include "path_1d.h"
#include "PID_Cntrl.h"
#include "Unwrapper_2pi.h"



extern EncoderCounter counter1,counter2;
extern EncoderCounterIndex index1,index2;
extern DiffCounter diff1,diff2;
extern path_1d *current_path;
extern LinearCharacteristics i2pwm;
extern PwmOut i_des1, i_des2;
extern DigitalOut i_enable;
extern Timer glob_ti;

// This is the loop class, it is not a controller at first hand, it guarantees a cyclic call
class ControllerLoop
{
public:
    ControllerLoop(float Ts);
    virtual     ~ControllerLoop();


private:
    void loop(void);
    Thread thread;
    Ticker ticker;
    ThreadFlag threadFlag;
    Timer ti;
    float Ts;
    void sendSignal();

};
