#ifndef Target_Planer_
#define Target_Planer_

#include <vector>

#include <mbed.h>

class Target_Planer
{
public:

    Target_Planer(double *Pathx, double *Pathy, uint16_t N, double R);
    
    virtual ~Target_Planer();
    
    void     initialize(double RobotPosx, double RobotPosy);
    void     update(double RobotPosx, double RobotPosy);
    void     readTargetPos(double *TargetPosx, double *TargetPosy);
    void     readTargetAng(double *TargetAng);
    void     readTarget(double *TargetPosx, double *TargetPosy, double *TargetAng);
    double   readTargetPosx();
    double   readTargetPosy();
    double   readTargetAng();
    void     updateAndReturnTarget(double RobotPosx, double RobotPosy, double *TargetPosx, double *TargetPosy, double *TargetAng);
        
    /* debug */
    double   returnPathxAtIndex(int i);
    double   returnPathyAtIndex(int i);
    uint16_t returnPathLength();
    uint16_t returnClosestPointOnPath(double RobotPosx, double RobotPosy);
    uint16_t return_i_min_();
    
private:

    struct PATH{
        vector<double> x;
        vector<double> y;
        uint16_t N;
    } Path_;
    
    struct ROBOTPOS{
        double x;
        double y;
    } RobotPos_;
    
    struct TARGETPOS{
        double x;
        double y;
    } TargetPos_;
    
    double TargetAng_;
    
    double   R_;
    double   del_;
    uint16_t i_min_;
    
    uint16_t findClosestPointOnPath(PATH Path, ROBOTPOS RobotPos);
    double   calcDistSquared(PATH Path, ROBOTPOS RobotPos, uint16_t i);
    double   calcNormPathsegment_i(PATH Path, uint16_t i);
    void     projectOnPath(PATH Path, ROBOTPOS RobotPos, uint16_t i, double *a_i, double *sx_i, double *sy_i, double *dl1_i);
    void     findIntersectionWithPath(double px_i, double py_i, double px_ip1, double py_ip1, double rx, double ry, bool *isvalid, double *x_intsec_valid, double *y_intsec_valid);
    void     transformDataOnPath(double px_i, double py_i, double px_ip1, double py_ip1, double rx, double ry, double *wp1x, double *wp1y, double *x_act, double *y_act, double *s_phi, double *c_phi);
    void     inverseTransformDataOnPath(double px_i, double py_i, double s_phi, double c_phi, double *x_intsec_valid_temp, double *y_intsec_valid_temp);
    
};

#endif