#ifndef PT1_Controller_
#define PT1_Controller_

#include <mbed.h>

class PT1_Controller
{
public:

    PT1_Controller(double Kp, double Ts, double Tf);
    PT1_Controller(double Kp, double Ts, double Tf, double u_max);
    PT1_Controller(double Kp, double Ts, double Tf, double u_max, double u_min);

    virtual ~PT1_Controller();
    
    void   reset();
    void   reset(double setVal);
    double update(double error);
    
private:

    double Kp, Ts, Tf;
    
    double u_max, u_min;
    
    double af, bf;
    double u_kmin1, uf_k;
    
    void   copyControllerPara(double Kp, double Ts, double Tf);
    void   calcFilterCoeff();
    double saturate(double u);
    
};

#endif