/* MS5611 Pressure sensor example
Aerodyne Labs
2014
 
This example uses the MS511 Library to read the temperature and pressure readings 
from the MS5611 sensor.  It has been modified from the MS507 sensor library with 
the different calculations that the MS5611 requires.  Otherwise, this library is
identical to the MS5607
------------
IndNav: Made adaptions, even though, the original works well, problem:
the original has a delay of 8ms from writing to reading (see line 73 in MS5611I2C.h)
Solution: seperate write and read in 2 processes (hene's hint):
    - write at end of data_read thread, without waiting
    - at beginning of next call, read the data
since there are 2 seperate reading/writings (one for pressure(altitude), one for Temperature -and we need both!)
toggle the 2 processes, this results, that only every 2nd pressure/altitude value is a new value!

altb 20.2.2020
*/
#include "mbed.h"
 
//Only uncomment the one needed.
//#include "MS5611SPI.h"
#include "MS5611I2C.h"
 
Serial pc(USBTX, USBRX);                   // local terminal interface
Timer timer;

int main() {
    pc.baud(115200);                        // set up USB serial speed
    timer.reset();
    timer.start();
    //Only uncomment the I2C or SPI version.
    //MS5611SPI ms5611(p11, p12, p13, p10);
    //MS5611I2C ms5611(p9, p10, false);
    //PB_9 and PB_8 for Nucleo boards
    I2C i2c(PB_3,PB_10);
    MS5611I2C ms5611(i2c, false);
    //Print the Coefficients from the 
    ms5611.printCoefficients();
    while(1){
        timer.reset();
//        float dum2 = ms5611.getTemperature();
//        float dum3 = ms5611.getAltitude();
//        printf("10 Durchlaeufe: %f sec \r\n", T);
//        printf("Pressure = %.0f Pa \r\n", ms5611.getPressure());
//        printf("Temperature = %.2f degC \r\n", ms5611.getTemperature());
        ms5611.getAltitude_toggle_Temp_write();
        wait_ms(100);
        printf("Altitude = %.2f m \r\n", ms5611.getAltitude_toggle_Temp_read());
        printf("Altitude = %.2f m \r\n", ms5611.getAltitude());
        float T = timer.read();
        wait(1.0);
    }
}