/*
Copyright (c) 2012, Senio Networks, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/*  MS5611 Modifications
Aerodyne Labs
Matthew Nelson - 2014
This library was originally the MS5607 library.  It has been modified to 
to be used the MS5611 Pressure sensor
*/

#ifndef MS5611_I2C_H
#define MS5611_I2C_H

#include "MS5611Base.h"

extern Serial pc;

class MS5611I2C : public MS5611Base {
public:
    MS5611I2C(I2C &i2c, int csb = 0) : i2c(i2c), i2cAddr(csb ? 0xEC : 0xEE) {
    wait(.01);
    i2c.frequency(400000);
    wait(.01);
    init();
    ADC_toggler = false;
    }

private:
    I2C &i2c;
    int i2cAddr;
    bool ADC_toggler;

    virtual void writeCommand(int command, int ms = 0) {
        char buf[1];
        buf[0] = command;
        i2c.write(i2cAddr, buf, 1);
        if (ms) wait_ms(ms);
    }

    virtual int readPROM(int address) {
            char buf[2];
            buf[0] = (PROM_READ | (address << 1));

        if (i2c.write(i2cAddr, buf, 1) == 0 &&
            i2c.read(i2cAddr, buf, 2) == 0)
            return buf[0] << 8 | buf[1];

        return -1;
    }

    virtual int readADC(int command) {
        char cmd[1];
        cmd[0] = (ADC_CONV | command);
        if (i2c.write(i2cAddr, cmd, 1) == 0) {
            static int duration[] = {500, 1100, 2100, 4100, 8220};        // OSR_4096
            wait_us(duration[(command & 0x0F) >> 1]);
            cmd[0] = ADC_READ;
            char buf[3];
            if (i2c.write(i2cAddr, cmd, sizeof(cmd)) == 0 &&
                i2c.read(i2cAddr, buf, sizeof(buf)) == 0){
                return buf[0] << 16 | buf[1] << 8 | buf[2];
                }
        }
        return -1;
    }
    virtual int readADC_write(int command) {
        char cmd[1];
        cmd[0] = (ADC_CONV | command);
        return (i2c.write(i2cAddr, cmd, 1)==0);
    }

    virtual int readADC_read(int command) {
        char cmd[1];
        cmd[0] = ADC_READ;
        char buf[3];
        if (i2c.write(i2cAddr, cmd, sizeof(cmd)) == 0 &&
            i2c.read(i2cAddr, buf, sizeof(buf)) == 0){
                     return buf[0] << 16 | buf[1] << 8 | buf[2];
            }
        return -1;
    }
};

#endif