#ifndef GPA_H_
#define GPA_H_

class GPA
{
public:

    typedef struct GPADATA {
        float   fexc;
        float   absGyu;
        float   angGyu;
        float   absGyr;
        float   angGyr;
        float   Umag;
        float   Ymag;
        float   Rmag;
        bool    MeasPointFinished;
    } gpadata_t;

    GPA(float fMin, float fMax, int NfexcDes, float Aexc0, float Aexc1, float Ts);
    GPA(float fMin, float fMax, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1, int Nstart, int Nsweep);
    GPA(float f0, float f1, float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1, int Nstart, int Nsweep);
    GPA(float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1, int Nstart, int Nsweep);
    GPA(float fMin, float fMax, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1, int Nstart, int Nsweep, bool doPrint);

    float operator()(float inp, float out)
    {
        return update((double)inp, (double)out);
    }

    virtual ~GPA();

    void     reset();
    float    update(double inp, double out);

    void     printGPAfexcDes();
    void     printGPAmeasPara();
    void     printGPAmeasTime();
    void     printNfexcDes();
    void     printLine();

    gpadata_t getGPAdata();

private:

    int     NfexcDes;
    int     NperMin;
    int     NmeasMin;
    double  Ts;
    double *fexcDes;
    double  aAexcDes;
    double  bAexcDes;

    double  fnyq;
    double  pi2;
    double  pi4;
    double  pi2Ts;
    double  piDiv2;
    double  rad2deg;
    double  div12pi;
    double  div812pi;

    int     Nmeas;
    int     Nper;
    double  dfexc;
    double  fexc;
    double  fexcPast;
    double  dfexcj;
    int     i;
    int     j;
    double  scaleG;
    double  cr;
    double  ci;
    double *sU;
    double *sY;
    double  sinarg;
    double  sinargR;
    int     NmeasTotal;
    double  Aexc;
    double  AexcPast;
    double  pi2Tsfexc;
    int     Nstart;
    int     Nsweep;
    int     Nsweep_i;
    double  AexcOut;

    gpadata_t gpaData;
    bool    doPrint;

    void    assignParameters(int NfexcDes, int NperMin, int NmeasMin, double Ts, int Nstart, int Nsweep);
    void    calculateDecreasingAmplitudeCoefficients(double Aexc0, double Aexc1);
    void    initializeConstants(double Ts);
    void    assignFilterStorage();
    void    fexcDesLogspace(double fMin, double fMax, int NfexcDes);
    void    calcGPAmeasPara(double fexcDes_i);
    double  wrapAngle(double angle);
    void    printLongLine();

};

#endif