#ifndef DT1_CNTRL_H_
#define DT1_CNTRL_H_

class DT1_Cntrl
{
public:

    DT1_Cntrl(float D, float tau_f, float Ts, float uMin, float uMax);

    float operator()(float e)
    {
        return doStep(e);
    }

    virtual ~DT1_Cntrl();

    void    reset(float initValue);
    float   doStep(float e);
    void    set_limits(float uMin, float uMax);
    void    setCoeff_D(float D);

private:

    float   eold, yold;               // signal storage
    float   uMax, uMin;               // max and min controll value
    float   Ts, tau_f, D, D_init, p;  // internal parameter storage

    void    setCoefficients(float D, float tau_f, float Ts);
};

#endif      // #DT1_CNTRL_H