#ifndef PID_CNTRL_H_
#define PID_CNTRL_H_

class PID_Cntrl
{
public:

    PID_Cntrl(float P, float I, float D, float tau_f, float Ts, float uMin, float uMax);
    PID_Cntrl(){};

    float operator()(float error) {
        return doStep(error);
    }
    float operator()(float error,float y) {
        return doStep(error,y);
    }

    virtual     ~PID_Cntrl();

    void        reset(float initValue);
    float       doStep(float error);
    float       doStep(float error,float y);
    void        set_limits(float ,float );
    float       get_ulimit(void);
    float       get_P_gain(void);
    void        setCoeff_P(float);
    void        setCoeff_I(float);
    void        setCoeff_D(float);
    void        scale_PID_param(float);
    void setCoefficients(float P, float I, float D, float tau_f, float Ts);
    void setCoefficients(float P, float I, float D, float tau_f, float Ts,float uMin, float uMax);
    
private:

    float Iold;
    float eold,yold,del,Dpart_old;
    float uMax;
    float uMin;
    float Ts,tau_f;
    float P,I,D_;
    float P_init, I_init, D__init;
    float p, Ka;

};

#endif      // #PID_CNTRL_H